"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var background_action_exports = {};
__export(background_action_exports, {
  OperationSchema: () => OperationSchema,
  defineBackgroundAction: () => defineBackgroundAction,
  lookupBackgroundAction: () => lookupBackgroundAction
});
module.exports = __toCommonJS(background_action_exports);
var z = __toESM(require("zod"));
var import_action = require("./action.js");
var import_error = require("./error.js");
var import_schema = require("./schema.js");
const OperationSchema = z.object({
  action: z.string().optional(),
  id: z.string(),
  done: z.boolean().optional(),
  output: z.any().optional(),
  error: z.object({ message: z.string() }).passthrough().optional(),
  metadata: z.record(z.string(), z.any()).optional()
});
async function lookupBackgroundAction(registry, key) {
  const root = await registry.lookupAction(key);
  if (!root) return void 0;
  const actionName = key.substring(key.indexOf("/", 1) + 1);
  return new BackgroundActionImpl(
    root,
    await registry.lookupAction(`/check-operation/${actionName}/check`),
    await registry.lookupAction(`/cancel-operation/${actionName}/cancel`)
  );
}
class BackgroundActionImpl {
  __action;
  startAction;
  checkAction;
  cancelAction;
  constructor(startAction, checkAction, cancelAction) {
    this.__action = {
      name: startAction.__action.name,
      description: startAction.__action.description,
      inputSchema: startAction.__action.inputSchema,
      inputJsonSchema: startAction.__action.inputJsonSchema,
      metadata: startAction.__action.metadata,
      actionType: startAction.__action.actionType
    };
    this.startAction = startAction;
    this.checkAction = checkAction;
    this.cancelAction = cancelAction;
  }
  async start(input, options) {
    return await this.startAction(input, options);
  }
  async check(operation) {
    return await this.checkAction(operation);
  }
  get supportsCancel() {
    return !!this.cancelAction;
  }
  async cancel(operation) {
    if (!this.cancelAction) {
      return operation;
    }
    return await this.cancelAction(operation);
  }
}
function defineBackgroundAction(registry, config) {
  const startAction = (0, import_action.defineAction)(
    registry,
    {
      actionType: config.actionType,
      name: config.name,
      description: config.description,
      inputSchema: config.inputSchema,
      inputJsonSchema: config.inputJsonSchema,
      outputSchema: OperationSchema,
      metadata: {
        ...config.metadata,
        outputSchema: (0, import_schema.toJsonSchema)({
          schema: config.outputSchema,
          jsonSchema: config.outputJsonSchema
        })
      },
      use: config.use
    },
    async (input, options) => {
      const operation = await config.start(input, options);
      operation.action = `/${config.actionType}/${config.name}`;
      return operation;
    }
  );
  const checkAction = (0, import_action.defineAction)(
    registry,
    {
      actionType: "check-operation",
      name: `${config.name}/check`,
      description: config.description,
      inputSchema: OperationSchema,
      inputJsonSchema: config.inputJsonSchema,
      outputSchema: OperationSchema,
      metadata: {
        ...config.metadata,
        outputSchema: (0, import_schema.toJsonSchema)({
          schema: config.outputSchema,
          jsonSchema: config.outputJsonSchema
        })
      }
    },
    async (input) => {
      const operation = await config.check(input);
      operation.action = `/${config.actionType}/${config.name}`;
      return operation;
    }
  );
  let cancelAction = void 0;
  if (config.cancel) {
    cancelAction = (0, import_action.defineAction)(
      registry,
      {
        actionType: "cancel-operation",
        name: `${config.name}/cancel`,
        description: config.description,
        inputSchema: OperationSchema,
        inputJsonSchema: config.inputJsonSchema,
        outputSchema: OperationSchema,
        metadata: {
          ...config.metadata,
          outputSchema: (0, import_schema.toJsonSchema)({
            schema: config.outputSchema,
            jsonSchema: config.outputJsonSchema
          })
        }
      },
      async (input) => {
        if (!config.cancel) {
          throw new import_error.GenkitError({
            status: "UNAVAILABLE",
            message: `${config.name} does not support cancellation.`
          });
        }
        const operation = await config.cancel(input);
        operation.action = `/${config.actionType}/${config.name}`;
        return operation;
      }
    );
  }
  return new BackgroundActionImpl(startAction, checkAction, cancelAction);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  OperationSchema,
  defineBackgroundAction,
  lookupBackgroundAction
});
//# sourceMappingURL=background-action.js.map