"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedSpanDataSchema = exports.TraceDataSchema = exports.SpanDataSchema = exports.InstrumentationLibrarySchema = exports.LinkSchema = exports.SpanContextSchema = exports.TimeEventSchema = exports.SpanStatusSchema = exports.SpanMetadataSchema = exports.TraceMetadataSchema = exports.PathMetadataSchema = void 0;
const zod_to_openapi_1 = require("@asteasolutions/zod-to-openapi");
const z = __importStar(require("zod"));
(0, zod_to_openapi_1.extendZodWithOpenApi)(z);
exports.PathMetadataSchema = z.object({
    path: z.string(),
    status: z.string(),
    error: z.string().optional(),
    latency: z.number(),
});
exports.TraceMetadataSchema = z.object({
    featureName: z.string().optional(),
    paths: z.set(exports.PathMetadataSchema).optional(),
    timestamp: z.number(),
});
exports.SpanMetadataSchema = z.object({
    name: z.string(),
    state: z.enum(['success', 'error']).optional(),
    input: z.any().optional(),
    output: z.any().optional(),
    isRoot: z.boolean().optional(),
    metadata: z.record(z.string(), z.string()).optional(),
    path: z.string().optional(),
});
exports.SpanStatusSchema = z.object({
    code: z.number(),
    message: z.string().optional(),
});
exports.TimeEventSchema = z.object({
    time: z.number(),
    annotation: z.object({
        attributes: z.record(z.string(), z.unknown()),
        description: z.string(),
    }),
});
exports.SpanContextSchema = z.object({
    traceId: z.string(),
    spanId: z.string(),
    isRemote: z.boolean().optional(),
    traceFlags: z.number(),
});
exports.LinkSchema = z.object({
    context: exports.SpanContextSchema.optional(),
    attributes: z.record(z.string(), z.unknown()).optional(),
    droppedAttributesCount: z.number().optional(),
});
exports.InstrumentationLibrarySchema = z.object({
    name: z.string().readonly(),
    version: z.string().optional().readonly(),
    schemaUrl: z.string().optional().readonly(),
});
exports.SpanDataSchema = z
    .object({
    spanId: z.string(),
    traceId: z.string(),
    parentSpanId: z.string().optional(),
    startTime: z.number(),
    endTime: z.number(),
    attributes: z.record(z.string(), z.unknown()),
    displayName: z.string(),
    links: z.array(exports.LinkSchema).optional(),
    instrumentationLibrary: exports.InstrumentationLibrarySchema,
    spanKind: z.string(),
    sameProcessAsParentSpan: z.object({ value: z.boolean() }).optional(),
    status: exports.SpanStatusSchema.optional(),
    timeEvents: z
        .object({
        timeEvent: z.array(exports.TimeEventSchema).optional(),
    })
        .optional(),
    truncated: z.boolean().optional(),
})
    .openapi('SpanData');
exports.TraceDataSchema = z
    .object({
    traceId: z.string(),
    displayName: z.string().optional(),
    startTime: z
        .number()
        .optional()
        .describe('trace start time in milliseconds since the epoch'),
    endTime: z
        .number()
        .optional()
        .describe('end time in milliseconds since the epoch'),
    spans: z.record(z.string(), exports.SpanDataSchema),
})
    .openapi('TraceData');
exports.NestedSpanDataSchema = exports.SpanDataSchema.extend({
    spans: z.lazy(() => z.array(exports.SpanDataSchema)),
});
//# sourceMappingURL=trace.js.map