import { z } from 'zod';
import zodToJsonSchema from 'zod-to-json-schema';
import { GenerateActionOptionsSchema, GenerateRequestSchema } from './model';
export const ModelInferenceInputSchema = z.union([
    z.string(),
    GenerateRequestSchema,
]);
export const ModelInferenceInputJSONSchema = zodToJsonSchema(ModelInferenceInputSchema, {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
export const GenerateRequestJSONSchema = zodToJsonSchema(GenerateRequestSchema, {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
export const GenerateInputJSONSchema = zodToJsonSchema(z.union([GenerateRequestSchema, GenerateActionOptionsSchema]), {
    $refStrategy: 'none',
    removeAdditionalStrategy: 'strict',
});
export const InferenceSampleSchema = z.object({
    testCaseId: z.string().optional(),
    input: z.any(),
    reference: z.any().optional(),
});
export const InferenceDatasetSchema = z.array(InferenceSampleSchema);
export const DatasetSchema = z.array(z.object({
    testCaseId: z.string(),
    input: z.any(),
    reference: z.any().optional(),
}));
export const EvaluationSampleSchema = z.object({
    testCaseId: z.string().optional(),
    input: z.any(),
    output: z.any(),
    error: z.string().optional(),
    context: z.array(z.any()).optional(),
    reference: z.any().optional(),
    traceIds: z.array(z.string()).optional(),
});
export const EvaluationDatasetSchema = z.array(EvaluationSampleSchema);
export const EvalInputSchema = z.object({
    testCaseId: z.string(),
    input: z.any(),
    output: z.any(),
    error: z.string().optional(),
    context: z.array(z.any()).optional(),
    reference: z.any().optional(),
    traceIds: z.array(z.string()),
});
export const EvalInputDatasetSchema = z.array(EvalInputSchema);
const EvalStatusEnumSchema = z.enum(['UNKNOWN', 'PASS', 'FAIL']);
export var EvalStatusEnum;
(function (EvalStatusEnum) {
    EvalStatusEnum["UNKNOWN"] = "UNKNOWN";
    EvalStatusEnum["PASS"] = "PASS";
    EvalStatusEnum["FAIL"] = "FAIL";
})(EvalStatusEnum || (EvalStatusEnum = {}));
export const EvalMetricSchema = z.object({
    evaluator: z.string(),
    scoreId: z.string().optional(),
    score: z.union([z.number(), z.string(), z.boolean()]).optional(),
    status: EvalStatusEnumSchema.optional(),
    rationale: z.string().optional(),
    error: z.string().optional(),
    traceId: z.string().optional(),
    spanId: z.string().optional(),
});
export const EvalResultSchema = EvalInputSchema.extend({
    metrics: z.array(EvalMetricSchema).optional(),
});
export const EvalRunKeySchema = z.object({
    actionRef: z.string().optional(),
    datasetId: z.string().optional(),
    datasetVersion: z.number().optional(),
    evalRunId: z.string(),
    createdAt: z.string(),
    actionConfig: z.any().optional(),
    metricSummaries: z.array(z.record(z.string(), z.any())).optional(),
});
export const EvalKeyAugmentsSchema = EvalRunKeySchema.pick({
    datasetId: true,
    datasetVersion: true,
    actionRef: true,
    actionConfig: true,
});
export const EvalRunSchema = z.object({
    key: EvalRunKeySchema,
    results: z.array(EvalResultSchema),
    metricsMetadata: z
        .record(z.string(), z.object({
        displayName: z.string(),
        definition: z.string(),
    }))
        .optional(),
});
export const DatasetSchemaSchema = z.object({
    inputSchema: z
        .record(z.any())
        .describe('Valid JSON Schema for the `input` field of dataset entry.')
        .optional(),
    referenceSchema: z
        .record(z.any())
        .describe('Valid JSON Schema for the `reference` field of dataset entry.')
        .optional(),
});
export const DatasetTypeSchema = z.enum(['UNKNOWN', 'FLOW', 'MODEL']);
export const DatasetMetadataSchema = z.object({
    datasetId: z.string(),
    size: z.number(),
    schema: DatasetSchemaSchema.optional(),
    datasetType: DatasetTypeSchema,
    targetAction: z.string().optional(),
    metricRefs: z.array(z.string()).default([]),
    version: z.number(),
    createTime: z.string(),
    updateTime: z.string(),
});
//# sourceMappingURL=eval.js.map