import { z } from 'zod';
import { GenerationCommonConfigSchema } from './model';
export const PromptFrontmatterSchema = z.object({
    name: z.string().optional(),
    variant: z.string().optional(),
    model: z.string().optional(),
    tools: z.array(z.string()).optional(),
    candidates: z.number().optional(),
    config: GenerationCommonConfigSchema.passthrough().optional(),
    input: z
        .object({
        schema: z.unknown(),
        default: z.any(),
    })
        .optional(),
    output: z
        .object({
        format: z.enum(['json', 'text', 'media']).optional(),
        schema: z.unknown().optional(),
    })
        .optional(),
    metadata: z.record(z.unknown()).optional(),
});
//# sourceMappingURL=prompt.js.map