import { type Action, type RunActionResponse } from '../types/action';
import * as apis from '../types/apis';
import type { TraceData } from '../types/trace';
import { type DevToolsInfo } from '../utils/utils';
import { RuntimeEvent, type RuntimeInfo, type StreamingCallback } from './types';
export declare const GENKIT_REFLECTION_API_SPEC_VERSION = 1;
interface RuntimeManagerOptions {
    telemetryServerUrl?: string;
    manageHealth?: boolean;
}
export declare class RuntimeManager {
    readonly telemetryServerUrl?: string | undefined;
    private manageHealth;
    private filenameToRuntimeMap;
    private filenameToDevUiMap;
    private idToFileMap;
    private eventEmitter;
    private constructor();
    static create(options: RuntimeManagerOptions): Promise<RuntimeManager>;
    listRuntimes(): Record<string, RuntimeInfo>;
    getRuntimeById(id: string): RuntimeInfo | undefined;
    getMostRecentRuntime(): RuntimeInfo | undefined;
    getMostRecentDevUI(): DevToolsInfo | undefined;
    onRuntimeEvent(listener: (eventType: RuntimeEvent, runtime: RuntimeInfo) => void): void;
    listActions(): Promise<Record<string, Action>>;
    runAction(input: apis.RunActionRequest, streamingCallback?: StreamingCallback<any>): Promise<RunActionResponse>;
    listTraces(input: apis.ListTracesRequest): Promise<apis.ListTracesResponse>;
    getTrace(input: apis.GetTraceRequest): Promise<TraceData>;
    private notifyRuntime;
    private setupRuntimesWatcher;
    private setupDevUiWatcher;
    private handleNewDevUi;
    private handleRemovedDevUi;
    private handleNewRuntime;
    private handleRemovedRuntime;
    private httpErrorHandler;
    private performHealthChecks;
    private removeRuntime;
}
export {};
