import { z } from 'zod';
export declare const TraceQueryFilterSchema: z.ZodObject<{
    eq: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber]>>>;
    neq: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber]>>>;
}, "strip", z.ZodTypeAny, {
    eq?: Record<string, string | number> | undefined;
    neq?: Record<string, string | number> | undefined;
}, {
    eq?: Record<string, string | number> | undefined;
    neq?: Record<string, string | number> | undefined;
}>;
export type TraceQueryFilter = z.infer<typeof TraceQueryFilterSchema>;
export declare const ListTracesRequestSchema: z.ZodObject<{
    limit: z.ZodOptional<z.ZodNumber>;
    continuationToken: z.ZodOptional<z.ZodString>;
    filter: z.ZodOptional<z.ZodObject<{
        eq: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber]>>>;
        neq: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber]>>>;
    }, "strip", z.ZodTypeAny, {
        eq?: Record<string, string | number> | undefined;
        neq?: Record<string, string | number> | undefined;
    }, {
        eq?: Record<string, string | number> | undefined;
        neq?: Record<string, string | number> | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    filter?: {
        eq?: Record<string, string | number> | undefined;
        neq?: Record<string, string | number> | undefined;
    } | undefined;
    limit?: number | undefined;
    continuationToken?: string | undefined;
}, {
    filter?: {
        eq?: Record<string, string | number> | undefined;
        neq?: Record<string, string | number> | undefined;
    } | undefined;
    limit?: number | undefined;
    continuationToken?: string | undefined;
}>;
export type ListTracesRequest = z.infer<typeof ListTracesRequestSchema>;
export declare const ListTracesResponseSchema: z.ZodObject<{
    traces: z.ZodArray<z.ZodObject<{
        traceId: z.ZodString;
        displayName: z.ZodOptional<z.ZodString>;
        startTime: z.ZodOptional<z.ZodNumber>;
        endTime: z.ZodOptional<z.ZodNumber>;
        spans: z.ZodRecord<z.ZodString, z.ZodObject<{
            spanId: z.ZodString;
            traceId: z.ZodString;
            parentSpanId: z.ZodOptional<z.ZodString>;
            startTime: z.ZodNumber;
            endTime: z.ZodNumber;
            attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
            displayName: z.ZodString;
            links: z.ZodOptional<z.ZodArray<z.ZodObject<{
                context: z.ZodOptional<z.ZodObject<{
                    traceId: z.ZodString;
                    spanId: z.ZodString;
                    isRemote: z.ZodOptional<z.ZodBoolean>;
                    traceFlags: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                }, {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                }>>;
                attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
                droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }, {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }>, "many">>;
            instrumentationLibrary: z.ZodObject<{
                name: z.ZodReadonly<z.ZodString>;
                version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
                schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
            }, "strip", z.ZodTypeAny, {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            }, {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            }>;
            spanKind: z.ZodString;
            sameProcessAsParentSpan: z.ZodOptional<z.ZodObject<{
                value: z.ZodBoolean;
            }, "strip", z.ZodTypeAny, {
                value: boolean;
            }, {
                value: boolean;
            }>>;
            status: z.ZodOptional<z.ZodObject<{
                code: z.ZodNumber;
                message: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                code: number;
                message?: string | undefined;
            }, {
                code: number;
                message?: string | undefined;
            }>>;
            timeEvents: z.ZodOptional<z.ZodObject<{
                timeEvent: z.ZodOptional<z.ZodArray<z.ZodObject<{
                    time: z.ZodNumber;
                    annotation: z.ZodObject<{
                        attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
                        description: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        description: string;
                        attributes: Record<string, unknown>;
                    }, {
                        description: string;
                        attributes: Record<string, unknown>;
                    }>;
                }, "strip", z.ZodTypeAny, {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }, {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }>, "many">>;
            }, "strip", z.ZodTypeAny, {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            }, {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            }>>;
            truncated: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        traceId: string;
        spans: Record<string, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>;
        displayName?: string | undefined;
        startTime?: number | undefined;
        endTime?: number | undefined;
    }, {
        traceId: string;
        spans: Record<string, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>;
        displayName?: string | undefined;
        startTime?: number | undefined;
        endTime?: number | undefined;
    }>, "many">;
    continuationToken: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    traces: {
        traceId: string;
        spans: Record<string, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>;
        displayName?: string | undefined;
        startTime?: number | undefined;
        endTime?: number | undefined;
    }[];
    continuationToken?: string | undefined;
}, {
    traces: {
        traceId: string;
        spans: Record<string, {
            traceId: string;
            spanId: string;
            displayName: string;
            attributes: Record<string, unknown>;
            startTime: number;
            endTime: number;
            instrumentationLibrary: {
                name: string;
                version?: string | undefined;
                schemaUrl?: string | undefined;
            };
            spanKind: string;
            status?: {
                code: number;
                message?: string | undefined;
            } | undefined;
            parentSpanId?: string | undefined;
            links?: {
                context?: {
                    traceId: string;
                    spanId: string;
                    traceFlags: number;
                    isRemote?: boolean | undefined;
                } | undefined;
                attributes?: Record<string, unknown> | undefined;
                droppedAttributesCount?: number | undefined;
            }[] | undefined;
            sameProcessAsParentSpan?: {
                value: boolean;
            } | undefined;
            timeEvents?: {
                timeEvent?: {
                    time: number;
                    annotation: {
                        description: string;
                        attributes: Record<string, unknown>;
                    };
                }[] | undefined;
            } | undefined;
            truncated?: boolean | undefined;
        }>;
        displayName?: string | undefined;
        startTime?: number | undefined;
        endTime?: number | undefined;
    }[];
    continuationToken?: string | undefined;
}>;
export type ListTracesResponse = z.infer<typeof ListTracesResponseSchema>;
export declare const GetTraceRequestSchema: z.ZodObject<{
    traceId: z.ZodString;
}, "strip", z.ZodTypeAny, {
    traceId: string;
}, {
    traceId: string;
}>;
export type GetTraceRequest = z.infer<typeof GetTraceRequestSchema>;
export declare const RunActionRequestSchema: z.ZodObject<{
    key: z.ZodString;
    input: z.ZodOptional<z.ZodAny>;
    context: z.ZodOptional<z.ZodAny>;
    telemetryLabels: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    key: string;
    input?: any;
    context?: any;
    telemetryLabels?: Record<string, string> | undefined;
}, {
    key: string;
    input?: any;
    context?: any;
    telemetryLabels?: Record<string, string> | undefined;
}>;
export type RunActionRequest = z.infer<typeof RunActionRequestSchema>;
export declare const CreatePromptRequestSchema: z.ZodObject<{
    model: z.ZodString;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["system", "user", "model", "tool"]>;
        content: z.ZodArray<z.ZodUnion<[z.ZodObject<{
            media: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            text: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            media: z.ZodObject<{
                contentType: z.ZodOptional<z.ZodString>;
                url: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                url: string;
                contentType?: string | undefined;
            }, {
                url: string;
                contentType?: string | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            media: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            toolRequest: z.ZodObject<{
                ref: z.ZodOptional<z.ZodString>;
                name: z.ZodString;
                input: z.ZodOptional<z.ZodUnknown>;
            }, "strip", z.ZodTypeAny, {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            }, {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            }>;
        }, "strip", z.ZodTypeAny, {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            media: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            toolResponse: z.ZodObject<{
                ref: z.ZodOptional<z.ZodString>;
                name: z.ZodString;
                output: z.ZodOptional<z.ZodUnknown>;
            }, "strip", z.ZodTypeAny, {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            }, {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            }>;
        }, "strip", z.ZodTypeAny, {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            media: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            data: z.ZodUnknown;
        }, "strip", z.ZodTypeAny, {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            media: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            reasoning: z.ZodOptional<z.ZodNever>;
        } & {
            custom: z.ZodRecord<z.ZodString, z.ZodAny>;
        }, "strip", z.ZodTypeAny, {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }, {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        }>, z.ZodObject<{
            text: z.ZodOptional<z.ZodNever>;
            media: z.ZodOptional<z.ZodNever>;
            toolRequest: z.ZodOptional<z.ZodNever>;
            toolResponse: z.ZodOptional<z.ZodNever>;
            data: z.ZodOptional<z.ZodUnknown>;
            metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            custom: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        } & {
            reasoning: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        }, {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        }>]>, "many">;
        metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        content: ({
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        } | {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        })[];
        role: "system" | "user" | "model" | "tool";
        metadata?: Record<string, unknown> | undefined;
    }, {
        content: ({
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        } | {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        })[];
        role: "system" | "user" | "model" | "tool";
        metadata?: Record<string, unknown> | undefined;
    }>, "many">;
    config: z.ZodOptional<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>>;
    tools: z.ZodOptional<z.ZodArray<z.ZodObject<{
        name: z.ZodString;
        description: z.ZodString;
        inputSchema: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>>;
        outputSchema: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>>;
        metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    }, "strip", z.ZodTypeAny, {
        description: string;
        name: string;
        inputSchema?: Record<string, any> | null | undefined;
        outputSchema?: Record<string, any> | null | undefined;
        metadata?: Record<string, any> | undefined;
    }, {
        description: string;
        name: string;
        inputSchema?: Record<string, any> | null | undefined;
        outputSchema?: Record<string, any> | null | undefined;
        metadata?: Record<string, any> | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    model: string;
    messages: {
        content: ({
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        } | {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        })[];
        role: "system" | "user" | "model" | "tool";
        metadata?: Record<string, unknown> | undefined;
    }[];
    tools?: {
        description: string;
        name: string;
        inputSchema?: Record<string, any> | null | undefined;
        outputSchema?: Record<string, any> | null | undefined;
        metadata?: Record<string, any> | undefined;
    }[] | undefined;
    config?: z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    model: string;
    messages: {
        content: ({
            text: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            reasoning: string;
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
        } | {
            media: {
                url: string;
                contentType?: string | undefined;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolRequest: {
                name: string;
                ref?: string | undefined;
                input?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            toolResponse: {
                name: string;
                ref?: string | undefined;
                output?: unknown;
            };
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom?: Record<string, unknown> | undefined;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        } | {
            custom: Record<string, any>;
            metadata?: Record<string, unknown> | undefined;
            text?: undefined;
            media?: undefined;
            toolRequest?: undefined;
            toolResponse?: undefined;
            data?: unknown;
            reasoning?: undefined;
        })[];
        role: "system" | "user" | "model" | "tool";
        metadata?: Record<string, unknown> | undefined;
    }[];
    tools?: {
        description: string;
        name: string;
        inputSchema?: Record<string, any> | null | undefined;
        outputSchema?: Record<string, any> | null | undefined;
        metadata?: Record<string, any> | undefined;
    }[] | undefined;
    config?: z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export type CreatePromptRequest = z.infer<typeof CreatePromptRequestSchema>;
export declare const PageViewSchema: z.ZodObject<{
    pageTitle: z.ZodString;
}, "strip", z.ZodTypeAny, {
    pageTitle: string;
}, {
    pageTitle: string;
}>;
export type PageView = z.infer<typeof PageViewSchema>;
export declare const ListEvalKeysRequestSchema: z.ZodObject<{
    filter: z.ZodOptional<z.ZodObject<{
        actionRef: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        actionRef?: string | undefined;
    }, {
        actionRef?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    filter?: {
        actionRef?: string | undefined;
    } | undefined;
}, {
    filter?: {
        actionRef?: string | undefined;
    } | undefined;
}>;
export type ListEvalKeysRequest = z.infer<typeof ListEvalKeysRequestSchema>;
export declare const ListEvalKeysResponseSchema: z.ZodObject<{
    evalRunKeys: z.ZodArray<z.ZodObject<{
        actionRef: z.ZodOptional<z.ZodString>;
        datasetId: z.ZodOptional<z.ZodString>;
        datasetVersion: z.ZodOptional<z.ZodNumber>;
        evalRunId: z.ZodString;
        createdAt: z.ZodString;
        actionConfig: z.ZodOptional<z.ZodAny>;
        metricSummaries: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>;
    }, "strip", z.ZodTypeAny, {
        evalRunId: string;
        createdAt: string;
        actionRef?: string | undefined;
        datasetId?: string | undefined;
        datasetVersion?: number | undefined;
        actionConfig?: any;
        metricSummaries?: Record<string, any>[] | undefined;
    }, {
        evalRunId: string;
        createdAt: string;
        actionRef?: string | undefined;
        datasetId?: string | undefined;
        datasetVersion?: number | undefined;
        actionConfig?: any;
        metricSummaries?: Record<string, any>[] | undefined;
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    evalRunKeys: {
        evalRunId: string;
        createdAt: string;
        actionRef?: string | undefined;
        datasetId?: string | undefined;
        datasetVersion?: number | undefined;
        actionConfig?: any;
        metricSummaries?: Record<string, any>[] | undefined;
    }[];
}, {
    evalRunKeys: {
        evalRunId: string;
        createdAt: string;
        actionRef?: string | undefined;
        datasetId?: string | undefined;
        datasetVersion?: number | undefined;
        actionConfig?: any;
        metricSummaries?: Record<string, any>[] | undefined;
    }[];
}>;
export type ListEvalKeysResponse = z.infer<typeof ListEvalKeysResponseSchema>;
export declare const GetEvalRunRequestSchema: z.ZodObject<{
    name: z.ZodString;
}, "strip", z.ZodTypeAny, {
    name: string;
}, {
    name: string;
}>;
export type GetEvalRunRequest = z.infer<typeof GetEvalRunRequestSchema>;
export declare const DeleteEvalRunRequestSchema: z.ZodObject<{
    name: z.ZodString;
}, "strip", z.ZodTypeAny, {
    name: string;
}, {
    name: string;
}>;
export type DeleteEvalRunRequest = z.infer<typeof DeleteEvalRunRequestSchema>;
export declare const CreateDatasetRequestSchema: z.ZodObject<{
    data: z.ZodArray<z.ZodObject<{
        testCaseId: z.ZodOptional<z.ZodString>;
        input: z.ZodAny;
        reference: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }, {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }>, "many">;
    datasetId: z.ZodOptional<z.ZodString>;
    datasetType: z.ZodEnum<["UNKNOWN", "FLOW", "MODEL"]>;
    schema: z.ZodOptional<z.ZodObject<{
        inputSchema: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
        referenceSchema: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    }, "strip", z.ZodTypeAny, {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    }, {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    }>>;
    metricRefs: z.ZodDefault<z.ZodArray<z.ZodString, "many">>;
    targetAction: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    data: {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }[];
    datasetType: "UNKNOWN" | "FLOW" | "MODEL";
    metricRefs: string[];
    schema?: {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    } | undefined;
    datasetId?: string | undefined;
    targetAction?: string | undefined;
}, {
    data: {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }[];
    datasetType: "UNKNOWN" | "FLOW" | "MODEL";
    schema?: {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    } | undefined;
    datasetId?: string | undefined;
    targetAction?: string | undefined;
    metricRefs?: string[] | undefined;
}>;
export type CreateDatasetRequest = z.infer<typeof CreateDatasetRequestSchema>;
export declare const UpdateDatasetRequestSchema: z.ZodObject<{
    datasetId: z.ZodString;
    data: z.ZodOptional<z.ZodArray<z.ZodObject<{
        testCaseId: z.ZodOptional<z.ZodString>;
        input: z.ZodAny;
        reference: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }, {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }>, "many">>;
    schema: z.ZodOptional<z.ZodObject<{
        inputSchema: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
        referenceSchema: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    }, "strip", z.ZodTypeAny, {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    }, {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    }>>;
    metricRefs: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    targetAction: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    datasetId: string;
    schema?: {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    } | undefined;
    data?: {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }[] | undefined;
    targetAction?: string | undefined;
    metricRefs?: string[] | undefined;
}, {
    datasetId: string;
    schema?: {
        inputSchema?: Record<string, any> | undefined;
        referenceSchema?: Record<string, any> | undefined;
    } | undefined;
    data?: {
        input?: any;
        testCaseId?: string | undefined;
        reference?: any;
    }[] | undefined;
    targetAction?: string | undefined;
    metricRefs?: string[] | undefined;
}>;
export type UpdateDatasetRequest = z.infer<typeof UpdateDatasetRequestSchema>;
export declare const RunNewEvaluationRequestSchema: z.ZodObject<{
    dataSource: z.ZodObject<{
        datasetId: z.ZodOptional<z.ZodString>;
        data: z.ZodOptional<z.ZodArray<z.ZodObject<{
            testCaseId: z.ZodOptional<z.ZodString>;
            input: z.ZodAny;
            reference: z.ZodOptional<z.ZodAny>;
        }, "strip", z.ZodTypeAny, {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }, {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    }, {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    }>;
    actionRef: z.ZodString;
    evaluators: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    options: z.ZodOptional<z.ZodObject<{
        context: z.ZodOptional<z.ZodString>;
        actionConfig: z.ZodOptional<z.ZodAny>;
        batchSize: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        context?: string | undefined;
        actionConfig?: any;
        batchSize?: number | undefined;
    }, {
        context?: string | undefined;
        actionConfig?: any;
        batchSize?: number | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    actionRef: string;
    dataSource: {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    };
    options?: {
        context?: string | undefined;
        actionConfig?: any;
        batchSize?: number | undefined;
    } | undefined;
    evaluators?: string[] | undefined;
}, {
    actionRef: string;
    dataSource: {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    };
    options?: {
        context?: string | undefined;
        actionConfig?: any;
        batchSize?: number | undefined;
    } | undefined;
    evaluators?: string[] | undefined;
}>;
export type RunNewEvaluationRequest = z.infer<typeof RunNewEvaluationRequestSchema>;
export declare const ValidateDataRequestSchema: z.ZodObject<{
    dataSource: z.ZodObject<{
        datasetId: z.ZodOptional<z.ZodString>;
        data: z.ZodOptional<z.ZodArray<z.ZodObject<{
            testCaseId: z.ZodOptional<z.ZodString>;
            input: z.ZodAny;
            reference: z.ZodOptional<z.ZodAny>;
        }, "strip", z.ZodTypeAny, {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }, {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    }, {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    }>;
    actionRef: z.ZodString;
}, "strip", z.ZodTypeAny, {
    actionRef: string;
    dataSource: {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    };
}, {
    actionRef: string;
    dataSource: {
        data?: {
            input?: any;
            testCaseId?: string | undefined;
            reference?: any;
        }[] | undefined;
        datasetId?: string | undefined;
    };
}>;
export type ValidateDataRequest = z.infer<typeof ValidateDataRequestSchema>;
export declare const ErrorDetailSchema: z.ZodObject<{
    path: z.ZodString;
    message: z.ZodString;
}, "strip", z.ZodTypeAny, {
    path: string;
    message: string;
}, {
    path: string;
    message: string;
}>;
export type ErrorDetail = z.infer<typeof ErrorDetailSchema>;
export declare const ValidateDataResponseSchema: z.ZodObject<{
    valid: z.ZodBoolean;
    errors: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        message: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        path: string;
        message: string;
    }, {
        path: string;
        message: string;
    }>, "many">>>;
}, "strip", z.ZodTypeAny, {
    valid: boolean;
    errors?: Record<string, {
        path: string;
        message: string;
    }[]> | undefined;
}, {
    valid: boolean;
    errors?: Record<string, {
        path: string;
        message: string;
    }[]> | undefined;
}>;
export type ValidateDataResponse = z.infer<typeof ValidateDataResponseSchema>;
