import { z } from 'zod';
export declare const BaseDataPointSchema: z.ZodObject<{
    input: z.ZodUnknown;
    output: z.ZodOptional<z.ZodUnknown>;
    context: z.ZodOptional<z.ZodArray<z.ZodUnknown, "many">>;
    reference: z.ZodOptional<z.ZodUnknown>;
    testCaseId: z.ZodOptional<z.ZodString>;
    traceIds: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    input?: unknown;
    output?: unknown;
    context?: unknown[] | undefined;
    testCaseId?: string | undefined;
    reference?: unknown;
    traceIds?: string[] | undefined;
}, {
    input?: unknown;
    output?: unknown;
    context?: unknown[] | undefined;
    testCaseId?: string | undefined;
    reference?: unknown;
    traceIds?: string[] | undefined;
}>;
export type BaseDataPoint = z.infer<typeof BaseDataPointSchema>;
export declare const BaseEvalDataPointSchema: z.ZodObject<{
    input: z.ZodUnknown;
    output: z.ZodOptional<z.ZodUnknown>;
    context: z.ZodOptional<z.ZodArray<z.ZodUnknown, "many">>;
    reference: z.ZodOptional<z.ZodUnknown>;
    traceIds: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
} & {
    testCaseId: z.ZodString;
}, "strip", z.ZodTypeAny, {
    testCaseId: string;
    input?: unknown;
    output?: unknown;
    context?: unknown[] | undefined;
    reference?: unknown;
    traceIds?: string[] | undefined;
}, {
    testCaseId: string;
    input?: unknown;
    output?: unknown;
    context?: unknown[] | undefined;
    reference?: unknown;
    traceIds?: string[] | undefined;
}>;
export type BaseEvalDataPoint = z.infer<typeof BaseEvalDataPointSchema>;
export declare const EvalStatusEnumSchema: z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>;
export declare const ScoreSchema: z.ZodObject<{
    id: z.ZodOptional<z.ZodString>;
    score: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString, z.ZodBoolean]>>;
    status: z.ZodOptional<z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>>;
    error: z.ZodOptional<z.ZodString>;
    details: z.ZodOptional<z.ZodObject<{
        reasoning: z.ZodOptional<z.ZodString>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        reasoning: z.ZodOptional<z.ZodString>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        reasoning: z.ZodOptional<z.ZodString>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
    id?: string | undefined;
    error?: string | undefined;
    score?: string | number | boolean | undefined;
    details?: z.objectOutputType<{
        reasoning: z.ZodOptional<z.ZodString>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
    id?: string | undefined;
    error?: string | undefined;
    score?: string | number | boolean | undefined;
    details?: z.objectInputType<{
        reasoning: z.ZodOptional<z.ZodString>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export type Score = z.infer<typeof ScoreSchema>;
export declare const EvalRequestSchema: z.ZodObject<{
    dataset: z.ZodArray<z.ZodObject<{
        input: z.ZodUnknown;
        output: z.ZodOptional<z.ZodUnknown>;
        context: z.ZodOptional<z.ZodArray<z.ZodUnknown, "many">>;
        reference: z.ZodOptional<z.ZodUnknown>;
        testCaseId: z.ZodOptional<z.ZodString>;
        traceIds: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        input?: unknown;
        output?: unknown;
        context?: unknown[] | undefined;
        testCaseId?: string | undefined;
        reference?: unknown;
        traceIds?: string[] | undefined;
    }, {
        input?: unknown;
        output?: unknown;
        context?: unknown[] | undefined;
        testCaseId?: string | undefined;
        reference?: unknown;
        traceIds?: string[] | undefined;
    }>, "many">;
    evalRunId: z.ZodString;
    options: z.ZodUnknown;
}, "strip", z.ZodTypeAny, {
    evalRunId: string;
    dataset: {
        input?: unknown;
        output?: unknown;
        context?: unknown[] | undefined;
        testCaseId?: string | undefined;
        reference?: unknown;
        traceIds?: string[] | undefined;
    }[];
    options?: unknown;
}, {
    evalRunId: string;
    dataset: {
        input?: unknown;
        output?: unknown;
        context?: unknown[] | undefined;
        testCaseId?: string | undefined;
        reference?: unknown;
        traceIds?: string[] | undefined;
    }[];
    options?: unknown;
}>;
export type EvalRequest = z.infer<typeof EvalRequestSchema>;
export declare const EvalFnResponseSchema: z.ZodObject<{
    sampleIndex: z.ZodOptional<z.ZodNumber>;
    testCaseId: z.ZodString;
    traceId: z.ZodOptional<z.ZodString>;
    spanId: z.ZodOptional<z.ZodString>;
    evaluation: z.ZodUnion<[z.ZodObject<{
        id: z.ZodOptional<z.ZodString>;
        score: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString, z.ZodBoolean]>>;
        status: z.ZodOptional<z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>>;
        error: z.ZodOptional<z.ZodString>;
        details: z.ZodOptional<z.ZodObject<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "strip", z.ZodTypeAny, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>, z.ZodArray<z.ZodObject<{
        id: z.ZodOptional<z.ZodString>;
        score: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString, z.ZodBoolean]>>;
        status: z.ZodOptional<z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>>;
        error: z.ZodOptional<z.ZodString>;
        details: z.ZodOptional<z.ZodObject<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "strip", z.ZodTypeAny, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>, "many">]>;
}, "strip", z.ZodTypeAny, {
    testCaseId: string;
    evaluation: {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } | {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }[];
    traceId?: string | undefined;
    spanId?: string | undefined;
    sampleIndex?: number | undefined;
}, {
    testCaseId: string;
    evaluation: {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } | {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }[];
    traceId?: string | undefined;
    spanId?: string | undefined;
    sampleIndex?: number | undefined;
}>;
export type EvalFnResponse = z.infer<typeof EvalFnResponseSchema>;
export declare const EvalResponseSchema: z.ZodArray<z.ZodObject<{
    sampleIndex: z.ZodOptional<z.ZodNumber>;
    testCaseId: z.ZodString;
    traceId: z.ZodOptional<z.ZodString>;
    spanId: z.ZodOptional<z.ZodString>;
    evaluation: z.ZodUnion<[z.ZodObject<{
        id: z.ZodOptional<z.ZodString>;
        score: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString, z.ZodBoolean]>>;
        status: z.ZodOptional<z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>>;
        error: z.ZodOptional<z.ZodString>;
        details: z.ZodOptional<z.ZodObject<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "strip", z.ZodTypeAny, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>, z.ZodArray<z.ZodObject<{
        id: z.ZodOptional<z.ZodString>;
        score: z.ZodOptional<z.ZodUnion<[z.ZodNumber, z.ZodString, z.ZodBoolean]>>;
        status: z.ZodOptional<z.ZodEnum<["UNKNOWN", "PASS", "FAIL"]>>;
        error: z.ZodOptional<z.ZodString>;
        details: z.ZodOptional<z.ZodObject<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "strip", z.ZodTypeAny, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>, "many">]>;
}, "strip", z.ZodTypeAny, {
    testCaseId: string;
    evaluation: {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } | {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectOutputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }[];
    traceId?: string | undefined;
    spanId?: string | undefined;
    sampleIndex?: number | undefined;
}, {
    testCaseId: string;
    evaluation: {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    } | {
        status?: "UNKNOWN" | "PASS" | "FAIL" | undefined;
        id?: string | undefined;
        error?: string | undefined;
        score?: string | number | boolean | undefined;
        details?: z.objectInputType<{
            reasoning: z.ZodOptional<z.ZodString>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }[];
    traceId?: string | undefined;
    spanId?: string | undefined;
    sampleIndex?: number | undefined;
}>, "many">;
export type EvalResponse = z.infer<typeof EvalResponseSchema>;
