import { z } from 'zod';
export declare const PromptFrontmatterSchema: z.ZodObject<{
    name: z.ZodOptional<z.ZodString>;
    variant: z.ZodOptional<z.ZodString>;
    model: z.ZodOptional<z.ZodString>;
    tools: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    candidates: z.ZodOptional<z.ZodNumber>;
    config: z.ZodOptional<z.ZodObject<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough">>>;
    input: z.ZodOptional<z.ZodObject<{
        schema: z.ZodUnknown;
        default: z.ZodAny;
    }, "strip", z.ZodTypeAny, {
        default?: any;
        schema?: unknown;
    }, {
        default?: any;
        schema?: unknown;
    }>>;
    output: z.ZodOptional<z.ZodObject<{
        format: z.ZodOptional<z.ZodEnum<["json", "text", "media"]>>;
        schema: z.ZodOptional<z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        format?: "text" | "media" | "json" | undefined;
        schema?: unknown;
    }, {
        format?: "text" | "media" | "json" | undefined;
        schema?: unknown;
    }>>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    metadata?: Record<string, unknown> | undefined;
    input?: {
        default?: any;
        schema?: unknown;
    } | undefined;
    output?: {
        format?: "text" | "media" | "json" | undefined;
        schema?: unknown;
    } | undefined;
    model?: string | undefined;
    tools?: string[] | undefined;
    config?: z.objectOutputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    candidates?: number | undefined;
    variant?: string | undefined;
}, {
    name?: string | undefined;
    metadata?: Record<string, unknown> | undefined;
    input?: {
        default?: any;
        schema?: unknown;
    } | undefined;
    output?: {
        format?: "text" | "media" | "json" | undefined;
        schema?: unknown;
    } | undefined;
    model?: string | undefined;
    tools?: string[] | undefined;
    config?: z.objectInputType<{
        version: z.ZodOptional<z.ZodString>;
        temperature: z.ZodOptional<z.ZodNumber>;
        maxOutputTokens: z.ZodOptional<z.ZodNumber>;
        topK: z.ZodOptional<z.ZodNumber>;
        topP: z.ZodOptional<z.ZodNumber>;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    candidates?: number | undefined;
    variant?: string | undefined;
}>;
export type PromptFrontmatter = z.infer<typeof PromptFrontmatterSchema>;
