import * as z from 'zod';
export declare const PathMetadataSchema: z.ZodObject<{
    path: z.ZodString;
    status: z.ZodString;
    error: z.ZodOptional<z.ZodString>;
    latency: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    path: string;
    status: string;
    latency: number;
    error?: string | undefined;
}, {
    path: string;
    status: string;
    latency: number;
    error?: string | undefined;
}>;
export type PathMetadata = z.infer<typeof PathMetadataSchema>;
export declare const TraceMetadataSchema: z.ZodObject<{
    featureName: z.ZodOptional<z.ZodString>;
    paths: z.ZodOptional<z.ZodSet<z.ZodObject<{
        path: z.ZodString;
        status: z.ZodString;
        error: z.ZodOptional<z.ZodString>;
        latency: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        path: string;
        status: string;
        latency: number;
        error?: string | undefined;
    }, {
        path: string;
        status: string;
        latency: number;
        error?: string | undefined;
    }>>>;
    timestamp: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    timestamp: number;
    featureName?: string | undefined;
    paths?: Set<{
        path: string;
        status: string;
        latency: number;
        error?: string | undefined;
    }> | undefined;
}, {
    timestamp: number;
    featureName?: string | undefined;
    paths?: Set<{
        path: string;
        status: string;
        latency: number;
        error?: string | undefined;
    }> | undefined;
}>;
export type TraceMetadata = z.infer<typeof TraceMetadataSchema>;
export declare const SpanMetadataSchema: z.ZodObject<{
    name: z.ZodString;
    state: z.ZodOptional<z.ZodEnum<["success", "error"]>>;
    input: z.ZodOptional<z.ZodAny>;
    output: z.ZodOptional<z.ZodAny>;
    isRoot: z.ZodOptional<z.ZodBoolean>;
    metadata: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    path: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    path?: string | undefined;
    metadata?: Record<string, string> | undefined;
    input?: any;
    output?: any;
    state?: "error" | "success" | undefined;
    isRoot?: boolean | undefined;
}, {
    name: string;
    path?: string | undefined;
    metadata?: Record<string, string> | undefined;
    input?: any;
    output?: any;
    state?: "error" | "success" | undefined;
    isRoot?: boolean | undefined;
}>;
export type SpanMetadata = z.infer<typeof SpanMetadataSchema>;
export declare const SpanStatusSchema: z.ZodObject<{
    code: z.ZodNumber;
    message: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    code: number;
    message?: string | undefined;
}, {
    code: number;
    message?: string | undefined;
}>;
export declare const TimeEventSchema: z.ZodObject<{
    time: z.ZodNumber;
    annotation: z.ZodObject<{
        attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        description: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        description: string;
        attributes: Record<string, unknown>;
    }, {
        description: string;
        attributes: Record<string, unknown>;
    }>;
}, "strip", z.ZodTypeAny, {
    time: number;
    annotation: {
        description: string;
        attributes: Record<string, unknown>;
    };
}, {
    time: number;
    annotation: {
        description: string;
        attributes: Record<string, unknown>;
    };
}>;
export declare const SpanContextSchema: z.ZodObject<{
    traceId: z.ZodString;
    spanId: z.ZodString;
    isRemote: z.ZodOptional<z.ZodBoolean>;
    traceFlags: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    traceId: string;
    spanId: string;
    traceFlags: number;
    isRemote?: boolean | undefined;
}, {
    traceId: string;
    spanId: string;
    traceFlags: number;
    isRemote?: boolean | undefined;
}>;
export declare const LinkSchema: z.ZodObject<{
    context: z.ZodOptional<z.ZodObject<{
        traceId: z.ZodString;
        spanId: z.ZodString;
        isRemote: z.ZodOptional<z.ZodBoolean>;
        traceFlags: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        traceId: string;
        spanId: string;
        traceFlags: number;
        isRemote?: boolean | undefined;
    }, {
        traceId: string;
        spanId: string;
        traceFlags: number;
        isRemote?: boolean | undefined;
    }>>;
    attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    context?: {
        traceId: string;
        spanId: string;
        traceFlags: number;
        isRemote?: boolean | undefined;
    } | undefined;
    attributes?: Record<string, unknown> | undefined;
    droppedAttributesCount?: number | undefined;
}, {
    context?: {
        traceId: string;
        spanId: string;
        traceFlags: number;
        isRemote?: boolean | undefined;
    } | undefined;
    attributes?: Record<string, unknown> | undefined;
    droppedAttributesCount?: number | undefined;
}>;
export declare const InstrumentationLibrarySchema: z.ZodObject<{
    name: z.ZodReadonly<z.ZodString>;
    version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
    schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    name: string;
    version?: string | undefined;
    schemaUrl?: string | undefined;
}, {
    name: string;
    version?: string | undefined;
    schemaUrl?: string | undefined;
}>;
export declare const SpanDataSchema: z.ZodObject<{
    spanId: z.ZodString;
    traceId: z.ZodString;
    parentSpanId: z.ZodOptional<z.ZodString>;
    startTime: z.ZodNumber;
    endTime: z.ZodNumber;
    attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    displayName: z.ZodString;
    links: z.ZodOptional<z.ZodArray<z.ZodObject<{
        context: z.ZodOptional<z.ZodObject<{
            traceId: z.ZodString;
            spanId: z.ZodString;
            isRemote: z.ZodOptional<z.ZodBoolean>;
            traceFlags: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        }, {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        }>>;
        attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }, {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }>, "many">>;
    instrumentationLibrary: z.ZodObject<{
        name: z.ZodReadonly<z.ZodString>;
        version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
        schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    }, {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    }>;
    spanKind: z.ZodString;
    sameProcessAsParentSpan: z.ZodOptional<z.ZodObject<{
        value: z.ZodBoolean;
    }, "strip", z.ZodTypeAny, {
        value: boolean;
    }, {
        value: boolean;
    }>>;
    status: z.ZodOptional<z.ZodObject<{
        code: z.ZodNumber;
        message: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message?: string | undefined;
    }, {
        code: number;
        message?: string | undefined;
    }>>;
    timeEvents: z.ZodOptional<z.ZodObject<{
        timeEvent: z.ZodOptional<z.ZodArray<z.ZodObject<{
            time: z.ZodNumber;
            annotation: z.ZodObject<{
                attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
                description: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                description: string;
                attributes: Record<string, unknown>;
            }, {
                description: string;
                attributes: Record<string, unknown>;
            }>;
        }, "strip", z.ZodTypeAny, {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }, {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    }, {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    }>>;
    truncated: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    traceId: string;
    spanId: string;
    displayName: string;
    attributes: Record<string, unknown>;
    startTime: number;
    endTime: number;
    instrumentationLibrary: {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    };
    spanKind: string;
    status?: {
        code: number;
        message?: string | undefined;
    } | undefined;
    parentSpanId?: string | undefined;
    links?: {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }[] | undefined;
    sameProcessAsParentSpan?: {
        value: boolean;
    } | undefined;
    timeEvents?: {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    } | undefined;
    truncated?: boolean | undefined;
}, {
    traceId: string;
    spanId: string;
    displayName: string;
    attributes: Record<string, unknown>;
    startTime: number;
    endTime: number;
    instrumentationLibrary: {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    };
    spanKind: string;
    status?: {
        code: number;
        message?: string | undefined;
    } | undefined;
    parentSpanId?: string | undefined;
    links?: {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }[] | undefined;
    sameProcessAsParentSpan?: {
        value: boolean;
    } | undefined;
    timeEvents?: {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    } | undefined;
    truncated?: boolean | undefined;
}>;
export type SpanData = z.infer<typeof SpanDataSchema>;
export declare const TraceDataSchema: z.ZodObject<{
    traceId: z.ZodString;
    displayName: z.ZodOptional<z.ZodString>;
    startTime: z.ZodOptional<z.ZodNumber>;
    endTime: z.ZodOptional<z.ZodNumber>;
    spans: z.ZodRecord<z.ZodString, z.ZodObject<{
        spanId: z.ZodString;
        traceId: z.ZodString;
        parentSpanId: z.ZodOptional<z.ZodString>;
        startTime: z.ZodNumber;
        endTime: z.ZodNumber;
        attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        displayName: z.ZodString;
        links: z.ZodOptional<z.ZodArray<z.ZodObject<{
            context: z.ZodOptional<z.ZodObject<{
                traceId: z.ZodString;
                spanId: z.ZodString;
                isRemote: z.ZodOptional<z.ZodBoolean>;
                traceFlags: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            }, {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            }>>;
            attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }, {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }>, "many">>;
        instrumentationLibrary: z.ZodObject<{
            name: z.ZodReadonly<z.ZodString>;
            version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
            schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        }>;
        spanKind: z.ZodString;
        sameProcessAsParentSpan: z.ZodOptional<z.ZodObject<{
            value: z.ZodBoolean;
        }, "strip", z.ZodTypeAny, {
            value: boolean;
        }, {
            value: boolean;
        }>>;
        status: z.ZodOptional<z.ZodObject<{
            code: z.ZodNumber;
            message: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            code: number;
            message?: string | undefined;
        }, {
            code: number;
            message?: string | undefined;
        }>>;
        timeEvents: z.ZodOptional<z.ZodObject<{
            timeEvent: z.ZodOptional<z.ZodArray<z.ZodObject<{
                time: z.ZodNumber;
                annotation: z.ZodObject<{
                    attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
                    description: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    description: string;
                    attributes: Record<string, unknown>;
                }, {
                    description: string;
                    attributes: Record<string, unknown>;
                }>;
            }, "strip", z.ZodTypeAny, {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }, {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }>, "many">>;
        }, "strip", z.ZodTypeAny, {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        }, {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        }>>;
        truncated: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    traceId: string;
    spans: Record<string, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }>;
    displayName?: string | undefined;
    startTime?: number | undefined;
    endTime?: number | undefined;
}, {
    traceId: string;
    spans: Record<string, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }>;
    displayName?: string | undefined;
    startTime?: number | undefined;
    endTime?: number | undefined;
}>;
export type TraceData = z.infer<typeof TraceDataSchema>;
export declare const NestedSpanDataSchema: z.ZodObject<{
    spanId: z.ZodString;
    traceId: z.ZodString;
    parentSpanId: z.ZodOptional<z.ZodString>;
    startTime: z.ZodNumber;
    endTime: z.ZodNumber;
    attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
    displayName: z.ZodString;
    links: z.ZodOptional<z.ZodArray<z.ZodObject<{
        context: z.ZodOptional<z.ZodObject<{
            traceId: z.ZodString;
            spanId: z.ZodString;
            isRemote: z.ZodOptional<z.ZodBoolean>;
            traceFlags: z.ZodNumber;
        }, "strip", z.ZodTypeAny, {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        }, {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        }>>;
        attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }, {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }>, "many">>;
    instrumentationLibrary: z.ZodObject<{
        name: z.ZodReadonly<z.ZodString>;
        version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
        schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    }, {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    }>;
    spanKind: z.ZodString;
    sameProcessAsParentSpan: z.ZodOptional<z.ZodObject<{
        value: z.ZodBoolean;
    }, "strip", z.ZodTypeAny, {
        value: boolean;
    }, {
        value: boolean;
    }>>;
    status: z.ZodOptional<z.ZodObject<{
        code: z.ZodNumber;
        message: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message?: string | undefined;
    }, {
        code: number;
        message?: string | undefined;
    }>>;
    timeEvents: z.ZodOptional<z.ZodObject<{
        timeEvent: z.ZodOptional<z.ZodArray<z.ZodObject<{
            time: z.ZodNumber;
            annotation: z.ZodObject<{
                attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
                description: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                description: string;
                attributes: Record<string, unknown>;
            }, {
                description: string;
                attributes: Record<string, unknown>;
            }>;
        }, "strip", z.ZodTypeAny, {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }, {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    }, {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    }>>;
    truncated: z.ZodOptional<z.ZodBoolean>;
} & {
    spans: z.ZodLazy<z.ZodArray<z.ZodObject<{
        spanId: z.ZodString;
        traceId: z.ZodString;
        parentSpanId: z.ZodOptional<z.ZodString>;
        startTime: z.ZodNumber;
        endTime: z.ZodNumber;
        attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
        displayName: z.ZodString;
        links: z.ZodOptional<z.ZodArray<z.ZodObject<{
            context: z.ZodOptional<z.ZodObject<{
                traceId: z.ZodString;
                spanId: z.ZodString;
                isRemote: z.ZodOptional<z.ZodBoolean>;
                traceFlags: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            }, {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            }>>;
            attributes: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            droppedAttributesCount: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }, {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }>, "many">>;
        instrumentationLibrary: z.ZodObject<{
            name: z.ZodReadonly<z.ZodString>;
            version: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
            schemaUrl: z.ZodReadonly<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        }, {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        }>;
        spanKind: z.ZodString;
        sameProcessAsParentSpan: z.ZodOptional<z.ZodObject<{
            value: z.ZodBoolean;
        }, "strip", z.ZodTypeAny, {
            value: boolean;
        }, {
            value: boolean;
        }>>;
        status: z.ZodOptional<z.ZodObject<{
            code: z.ZodNumber;
            message: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            code: number;
            message?: string | undefined;
        }, {
            code: number;
            message?: string | undefined;
        }>>;
        timeEvents: z.ZodOptional<z.ZodObject<{
            timeEvent: z.ZodOptional<z.ZodArray<z.ZodObject<{
                time: z.ZodNumber;
                annotation: z.ZodObject<{
                    attributes: z.ZodRecord<z.ZodString, z.ZodUnknown>;
                    description: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    description: string;
                    attributes: Record<string, unknown>;
                }, {
                    description: string;
                    attributes: Record<string, unknown>;
                }>;
            }, "strip", z.ZodTypeAny, {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }, {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }>, "many">>;
        }, "strip", z.ZodTypeAny, {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        }, {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        }>>;
        truncated: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }, {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    traceId: string;
    spanId: string;
    displayName: string;
    attributes: Record<string, unknown>;
    startTime: number;
    endTime: number;
    instrumentationLibrary: {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    };
    spanKind: string;
    spans: {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }[];
    status?: {
        code: number;
        message?: string | undefined;
    } | undefined;
    parentSpanId?: string | undefined;
    links?: {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }[] | undefined;
    sameProcessAsParentSpan?: {
        value: boolean;
    } | undefined;
    timeEvents?: {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    } | undefined;
    truncated?: boolean | undefined;
}, {
    traceId: string;
    spanId: string;
    displayName: string;
    attributes: Record<string, unknown>;
    startTime: number;
    endTime: number;
    instrumentationLibrary: {
        name: string;
        version?: string | undefined;
        schemaUrl?: string | undefined;
    };
    spanKind: string;
    spans: {
        traceId: string;
        spanId: string;
        displayName: string;
        attributes: Record<string, unknown>;
        startTime: number;
        endTime: number;
        instrumentationLibrary: {
            name: string;
            version?: string | undefined;
            schemaUrl?: string | undefined;
        };
        spanKind: string;
        status?: {
            code: number;
            message?: string | undefined;
        } | undefined;
        parentSpanId?: string | undefined;
        links?: {
            context?: {
                traceId: string;
                spanId: string;
                traceFlags: number;
                isRemote?: boolean | undefined;
            } | undefined;
            attributes?: Record<string, unknown> | undefined;
            droppedAttributesCount?: number | undefined;
        }[] | undefined;
        sameProcessAsParentSpan?: {
            value: boolean;
        } | undefined;
        timeEvents?: {
            timeEvent?: {
                time: number;
                annotation: {
                    description: string;
                    attributes: Record<string, unknown>;
                };
            }[] | undefined;
        } | undefined;
        truncated?: boolean | undefined;
    }[];
    status?: {
        code: number;
        message?: string | undefined;
    } | undefined;
    parentSpanId?: string | undefined;
    links?: {
        context?: {
            traceId: string;
            spanId: string;
            traceFlags: number;
            isRemote?: boolean | undefined;
        } | undefined;
        attributes?: Record<string, unknown> | undefined;
        droppedAttributesCount?: number | undefined;
    }[] | undefined;
    sameProcessAsParentSpan?: {
        value: boolean;
    } | undefined;
    timeEvents?: {
        timeEvent?: {
            time: number;
            annotation: {
                description: string;
                attributes: Record<string, unknown>;
            };
        }[] | undefined;
    } | undefined;
    truncated?: boolean | undefined;
}>;
export type NestedSpanData = z.infer<typeof SpanDataSchema> & {
    spans?: SpanData[];
};
