"use client";

import { useForm } from "react-hook-form";
import { zodResolver } from "@hookform/resolvers/zod";
import { z } from "zod";
import { AppLayout } from "@/components/layout/AppLayout";
import { CreateAgentForm, formSchema } from "./CreateAgentForm";
import { AgentTestChat } from "./AgentTestChat";
import { Bot } from "lucide-react";

export default function CreateAgentPage() {
    const form = useForm<z.infer<typeof formSchema>>({
    resolver: zodResolver(formSchema),
    defaultValues: {
      agentName: "",
      agentDescription: "",
      persona: "",
      toneOfVoice: "",
      knowledgeBaseText: "",
      knowledgeBaseUrl: "",
      customInstructions: "",
    },
    mode: "onChange",
  });

  const agentName = form.watch("agentName");
  const persona = form.watch("persona");

  return (
    <AppLayout>
      <div className="flex items-center gap-4 mb-4">
        <div className="p-3 bg-primary/10 rounded-lg">
          <Bot className="h-8 w-8 text-primary" />
        </div>
        <div>
           <h1 className="text-4xl font-bold font-headline tracking-tight">
            Crie Seu Agente de IA
          </h1>
           <p className="text-muted-foreground mt-1">
            Preencha o formulário para dar vida ao seu agente e teste-o em tempo real.
          </p>
        </div>
      </div>
     
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 mt-8">
        <div className="max-w-full">
            <CreateAgentForm form={form} />
        </div>
        <div className="max-w-full">
            <AgentTestChat agentName={agentName} persona={persona} />
        </div>
      </div>

    </AppLayout>
  );
}
