
"use client";

import Image from "next/image";
import { AppLayout } from "@/components/layout/AppLayout";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Settings } from "lucide-react";

const integrations = [
    {
        name: "WhatsApp",
        description: "Connect your agents to WhatsApp Business for chat automation.",
        logo: "/whatsapp-logo.svg",
        connected: true,
    },
    {
        name: "Instagram",
        description: "Integrate with Instagram Messenger to engage your followers.",
        logo: "/instagram-logo.svg",
        connected: false,
    },
    {
        name: "Telegram",
        description: "Use the Telegram Bot API to create interactive agents.",
        logo: "/telegram-logo.svg",
        connected: false,
    },
     {
        name: "Website",
        description: "Embed your agent on any website with a simple code snippet.",
        logo: "/website-logo.svg",
        connected: true,
    },
];

export default function IntegrationsPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "My Agents",
        sales: "Sales",
        purchases: "Purchases",
        integrations: "Integrations",
        support: "Support",
        marketplace: "Marketplace",
        createAgent: "Create Agent",
        settings: "Settings",
        logout: "Logout",
    };
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Channel Integrations
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Connect your agents to different channels to reach your customers where they are.
        </p>

        <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        {integrations.map((integration) => (
            <Card key={integration.name}>
                <CardHeader>
                    <div className="flex items-start justify-between gap-4">
                        <div className="flex items-center gap-4">
                            <Image src={integration.logo} alt={`${integration.name} logo`} width={40} height={40} />
                            <div>
                                <CardTitle className="font-headline text-xl">{integration.name}</CardTitle>
                                <CardDescription className="mt-1">{integration.connected ? "Connected" : "Not connected"}</CardDescription>
                            </div>
                        </div>
                    </div>
                </CardHeader>
                <CardContent>
                    <p className="text-sm text-muted-foreground mb-4">{integration.description}</p>
                     <Button variant={integration.connected ? "secondary" : "default"} className="w-full">
                        {integration.connected ? <Settings className="mr-2 h-4 w-4"/> : null}
                        {integration.connected ? "Manage" : "Connect"}
                    </Button>
                </CardContent>
            </Card>
        ))}
        </div>
    </AppLayout>
  );
}
