
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Button } from "@/components/ui/button";
import { PlusCircle } from "lucide-react";
import { AgentCard } from "@/components/agent/AgentCard";
import { agents } from "@/lib/mock-data";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function MyAgentsPage() {
    const createdAgents = agents.slice(0, 2);
    const purchasedAgents = agents.slice(2, 4);
    const draftAgent = {
        ...agents[0],
        id: 'draft-1',
        name: "Draft Agent",
        description: "This agent is still under development...",
    }

    const translations = {
        dashboard: "Dashboard",
        myAgents: "My Agents",
        sales: "Sales",
        purchases: "Purchases",
        myAccount: "My Account",
        support: "Support",
        marketplace: "Marketplace",
        createAgent: "Create Agent",
        settings: "Settings",
        logout: "Logout",
    };
    return (
        <AppLayout translations={translations}>
            <div className="flex items-center justify-between mb-8">
                <div>
                    <h1 className="text-3xl font-bold font-headline">My Agents</h1>
                    <p className="text-muted-foreground">Manage, edit, or create new agents.</p>
                </div>
                 <AgentTypeSelectionDialog 
                    trigger={
                        <Button>
                            <PlusCircle className="mr-2"/>
                            Create New Agent
                        </Button>
                    }
                    locale="en"
                />
            </div>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                <AgentCard agent={draftAgent} variant="draft"/>
                {createdAgents.map((agent) => (
                    <AgentCard key={`created-${agent.id}`} agent={agent} variant="created"/>
                ))}
                {purchasedAgents.map((agent) => (
                    <AgentCard key={`purchased-${agent.id}`} agent={agent} variant="purchased"/>
                ))}
            </div>
        </AppLayout>
    )
}
