
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import { Button } from "@/components/ui/button";
import { FileDown, DollarSign, Eye, Users, Bot } from "lucide-react";
import { StatsCard } from "@/components/dashboard/StatsCard";
import { SalesChart } from "@/app/en/dashboard/SalesChart";

const sales = [
  {
    id: "1",
    agentName: "FinancePro Bot",
    buyerName: "John Doe",
    buyerEmail: "john.d@example.com",
    date: "2024-07-20",
    price: 49.99,
    commission: 39.99,
  },
  {
    id: "2",
    agentName: "Marketing Guru",
    buyerName: "Jane Smith",
    buyerEmail: "jane.s@example.com",
    date: "2024-07-19",
    price: 79.0,
    commission: 63.20,
  },
   {
    id: "3",
    agentName: "FinancePro Bot",
    buyerName: "Peter Jones",
    buyerEmail: "peter.j@example.com",
    date: "2024-07-18",
    price: 49.99,
    commission: 39.99,
  },
];

export default function SalesPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "My Agents",
        sales: "Sales",
        purchases: "Purchases",
        myAccount: "My Account",
        support: "Support",
        marketplace: "Marketplace",
        createAgent: "Create Agent",
        settings: "Settings",
        logout: "Logout",
        affiliates: "Affiliates",
    };
  return (
    <AppLayout translations={translations}>
        <div className="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 className="text-3xl font-bold font-headline tracking-tight">
                    Sales
                </h1>
                <p className="text-muted-foreground mt-1">
                    Track your sales history and revenue.
                </p>
            </div>
            <Button>
                <FileDown className="mr-2 h-4 w-4" />
                Export CSV
            </Button>
        </div>

        <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-4 mb-8">
          <StatsCard
            title="Total Sales"
            value="$12,450"
            icon={DollarSign}
            change="+12.5% from last month"
          />
          <StatsCard
            title="Agent Views"
            value="245,830"
            icon={Eye}
            change="+8.2% from last month"
          />
          <StatsCard
            title="Active Customers"
            value="1,284"
            icon={Users}
            change="-1.5% from last month"
            changeType="decrease"
          />
          <StatsCard
            title="Active Agents"
            value="12"
            icon={Bot}
            change="+2 from last month"
          />
        </div>

        <div className="mb-8">
            <SalesChart />
        </div>

        <Card>
        <CardHeader>
            <CardTitle>Sales History</CardTitle>
            <CardDescription>
            Here is the list of all your sales.
            </CardDescription>
        </CardHeader>
        <CardContent>
            <Table>
            <TableHeader>
                <TableRow>
                <TableHead>Agent</TableHead>
                <TableHead>Buyer</TableHead>
                <TableHead>Date</TableHead>
                <TableHead className="text-right">Total Amount</TableHead>
                <TableHead className="text-right">Your Commission</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {sales.map((sale) => (
                <TableRow key={sale.id}>
                    <TableCell className="font-medium">{sale.agentName}</TableCell>
                    <TableCell>
                    <div className="font-medium">{sale.buyerName}</div>
                    <div className="text-sm text-muted-foreground">{sale.buyerEmail}</div>
                    </TableCell>
                    <TableCell>{sale.date}</TableCell>
                    <TableCell className="text-right">
                    ${sale.price.toFixed(2)}
                    </TableCell>
                    <TableCell className="text-right font-semibold text-primary">
                    ${sale.commission.toFixed(2)}
                    </TableCell>
                </TableRow>
                ))}
            </TableBody>
            </Table>
        </CardContent>
        </Card>
    </AppLayout>
  );
}
