
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { StatsCard } from "@/components/dashboard/StatsCard";
import { SalesChart } from "@/app/es/dashboard/SalesChart";
import { DollarSign, Eye, Users, Bot, FileDown } from "lucide-react";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { Button } from "@/components/ui/button";

const recentSales = [
  {
    id: "1",
    agentName: "FinancePro Bot",
    buyerName: "John Doe",
    buyerEmail: "john.d@example.com",
    date: "2024-07-20",
    price: 49.99,
  },
  {
    id: "2",
    agentName: "Marketing Guru",
    buyerName: "Jane Smith",
    buyerEmail: "jane.s@example.com",
    date: "2024-07-19",
    price: 79.0,
  },
   {
    id: "3",
    agentName: "FinancePro Bot",
    buyerName: "Peter Jones",
    buyerEmail: "peter.j@example.com",
    date: "2024-07-18",
    price: 49.99,
  },
];


export default function DashboardPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Mis Agentes",
        sales: "Ventas",
        purchases: "Compras",
        myAccount: "Mi Cuenta",
        support: "Soporte",
        marketplace: "Marketplace",
        createAgent: "Crear Agente",
        settings: "Configuración",
        logout: "Cerrar Sesión",
        affiliates: "Afiliados",
    };
  
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline mb-8">Dashboard</h1>
        
         <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-4 mb-8">
          <StatsCard
            title="Ventas Totales"
            value="$12,450"
            icon={DollarSign}
            change="+12.5% del último mes"
          />
          <StatsCard
            title="Vistas de Agentes"
            value="245,830"
            icon={Eye}
            change="+8.2% del último mes"
          />
          <StatsCard
            title="Clientes Activos"
            value="1,284"
            icon={Users}
            change="-1.5% del último mes"
            changeType="decrease"
          />
          <StatsCard
            title="Agentes Activos"
            value="12"
            icon={Bot}
            change="+2 del último mes"
          />
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div className="lg:col-span-2">
                <SalesChart />
            </div>
            <div>
                 <Card>
                    <CardHeader>
                        <CardTitle>Ventas Recientes</CardTitle>
                        <CardDescription>Un vistazo rápido a tus ventas más recientes.</CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Table>
                             <TableHeader>
                                <TableRow>
                                <TableHead>Agente</TableHead>
                                <TableHead className="text-right">Precio</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                {recentSales.map((sale) => (
                                    <TableRow key={sale.id}>
                                        <TableCell>
                                            <div className="font-medium">{sale.agentName}</div>
                                            <div className="text-sm text-muted-foreground">{sale.buyerEmail}</div>
                                        </TableCell>
                                        <TableCell className="text-right font-semibold text-primary">
                                            ${sale.price.toFixed(2)}
                                        </TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                         <Button variant="outline" className="w-full mt-4">Ver Todas las Ventas</Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </AppLayout>
  );
}
