
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Button } from "@/components/ui/button";
import { PlusCircle } from "lucide-react";
import { AgentCard } from "@/components/agent/AgentCard";
import { agents } from "@/lib/mock-data";
import { AgentTypeSelectionDialog } from "@/components/agent/AgentTypeSelectionDialog";

export default function MyAgentsPage() {
    const createdAgents = agents.slice(0, 2);
    const purchasedAgents = agents.slice(2, 4);
    const draftAgent = {
        ...agents[0],
        id: 'draft-1',
        name: "Agente en Borrador",
        description: "Este agente todavía está en desarrollo...",
    }


    const translations = {
        dashboard: "Dashboard",
        myAgents: "Mis Agentes",
        sales: "Ventas",
        purchases: "Compras",
        myAccount: "Mi Cuenta",
        support: "Soporte",
        marketplace: "Marketplace",
        createAgent: "Crear Agente",
        settings: "Configuración",
        logout: "Cerrar Sesión",
    };
    return (
        <AppLayout translations={translations}>
            <div className="flex items-center justify-between mb-8">
                <div>
                    <h1 className="text-3xl font-bold font-headline">Mis Agentes</h1>
                    <p className="text-muted-foreground">Gestiona, edita o crea nuevos agentes.</p>
                </div>
                <AgentTypeSelectionDialog 
                    trigger={
                        <Button>
                            <PlusCircle className="mr-2"/>
                            Crear Nuevo Agente
                        </Button>
                    }
                    locale="es"
                />
            </div>
            
             <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                <AgentCard agent={draftAgent} variant="draft"/>
                {createdAgents.map((agent) => (
                    <AgentCard key={`created-${agent.id}`} agent={agent} variant="created"/>
                ))}
                {purchasedAgents.map((agent) => (
                    <AgentCard key={`purchased-${agent.id}`} agent={agent} variant="purchased"/>
                ))}
            </div>

        </AppLayout>
    )
}
