
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { KeyRound } from "lucide-react";

const purchasedAgents = [
  {
    id: "1",
    name: "FinancePro Bot",
    purchaseDate: "2024-07-15",
    status: "Active",
    price: 49.99,
  },
  {
    id: "2",
    name: "Marketing Guru",
    purchaseDate: "2024-06-28",
    status: "Active",
    price: 79.0,
  },
  {
    id: "4",
    name: "CodeHelper",
    purchaseDate: "2024-05-10",
    status: "Expired",
    price: 99.0,
  },
];

export default function PurchasesPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Mis Agentes",
        sales: "Ventas",
        purchases: "Compras",
        myAccount: "Mi Cuenta",
        support: "Soporte",
        marketplace: "Marketplace",
        createAgent: "Crear Agente",
        settings: "Configuración",
        logout: "Cerrar Sesión",
    };
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight mb-2">
            Mis Compras
        </h1>
        <p className="text-muted-foreground mb-8">
            Gestiona tus agentes comprados y accede a sus claves.
        </p>
        <Card>
        <CardHeader>
            <CardTitle>Agentes Adquiridos</CardTitle>
            <CardDescription>
            Aquí está la lista de todos los agentes que has comprado.
            </CardDescription>
        </CardHeader>
        <CardContent>
            <Table>
            <TableHeader>
                <TableRow>
                <TableHead>Agente</TableHead>
                <TableHead>Fecha de Compra</TableHead>
                <TableHead>Estado</TableHead>
                <TableHead className="text-right">Precio</TableHead>
                <TableHead className="text-center">Acciones</TableHead>
                </TableRow>
            </TableHeader>
            <TableBody>
                {purchasedAgents.map((agent) => (
                <TableRow key={agent.id}>
                    <TableCell className="font-medium">{agent.name}</TableCell>
                    <TableCell>{agent.purchaseDate}</TableCell>
                    <TableCell>
                    <Badge
                        variant={agent.status === 'Active' ? 'default' : 'destructive'}
                        className={
                        agent.status === 'Active'
                            ? 'bg-emerald-500/20 text-emerald-500 border-transparent hover:bg-emerald-500/30'
                            : 'bg-red-500/20 text-red-500 border-transparent hover:bg-red-500/30'
                        }
                    >
                        {agent.status === 'Active' ? 'Activo' : 'Expirado'}
                    </Badge>
                    </TableCell>
                    <TableCell className="text-right">
                    ${agent.price.toFixed(2)}
                    </TableCell>
                    <TableCell className="text-center">
                    <Button variant="outline" size="sm">
                        <KeyRound className="mr-2 h-4 w-4" />
                        Ver Clave
                    </Button>
                    </TableCell>
                </TableRow>
                ))}
            </TableBody>
            </Table>
        </CardContent>
        </Card>
    </AppLayout>
  );
}
