
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { CreditCard, Shield, LifeBuoy, Mail, Phone, Link as LinkIcon, Globe } from "lucide-react";
import { Separator } from "@/components/ui/separator";
import Link from "next/link";
import { usePathname } from "next/navigation";


export default function SettingsPage() {
    const pathname = usePathname();
    const locale = pathname.split('/')[1] || 'pt';

    const translations = {
        dashboard: "Dashboard",
        myAgents: "Mis Agentes",
        sales: "Ventas",
        purchases: "Compras",
        myAccount: "Mi Cuenta",
        support: "Soporte",
        marketplace: "Marketplace",
        createAgent: "Crear Agente",
        settings: "Configuración",
        logout: "Cerrar Sesión",
        affiliates: "Afiliados",
    };

    const SocialInput = ({ id, name, placeholder, icon: Icon }: { id: string, name: string, placeholder: string, icon: React.ElementType }) => (
         <div className="grid gap-2">
            <Label htmlFor={id}>{name}</Label>
            <div className="flex items-center gap-2">
                <Icon className="h-5 w-5 text-muted-foreground" />
                <Input id={id} placeholder={placeholder} />
            </div>
        </div>
    );

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Mi Cuenta
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Gestiona tu información de perfil, pagos y seguridad.
        </p>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
             <div className="lg:col-span-2 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle>Perfil Público</CardTitle>
                    <CardDescription>
                        Esta información se mostrará en tu página de creador.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-6">
                        <div className="flex items-center gap-4">
                        <Avatar className="h-16 w-16">
                            <AvatarImage src="https://placehold.co/100x100.png" alt="Creator Name" />
                            <AvatarFallback>CN</AvatarFallback>
                        </Avatar>
                        <Button variant="outline">Cambiar Foto</Button>
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="fullName">Nombre a Mostrar</Label>
                        <Input id="fullName" defaultValue="InvestCorp" />
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="bio">Biografía</Label>
                        <Textarea id="bio" defaultValue="Pioneros en IA para el mercado financiero, creando bots que simplifican análisis complejos y ayudan en las decisiones de inversión." />
                    </div>
                     <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <SocialInput id="public-email" name="Correo Público" placeholder="contacto@ejemplo.com" icon={Mail} />
                        <SocialInput id="phone" name="Teléfono" placeholder="+1 (555) 123-4567" icon={Phone} />
                        <SocialInput id="website" name="Sitio Web" placeholder="https://ejemplo.com" icon={Globe} />
                        <SocialInput id="twitter" name="Twitter" placeholder="https://twitter.com/usuario" icon={LinkIcon} />
                        <SocialInput id="linkedin" name="LinkedIn" placeholder="https://linkedin.com/in/usuario" icon={LinkIcon} />
                        <SocialInput id="github" name="GitHub" placeholder="https://github.com/usuario" icon={LinkIcon} />
                    </div>
                    <Button>Guardar Perfil</Button>
                    </CardContent>
                </Card>

                 <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><Shield className="h-5 w-5"/> Seguridad</CardTitle>
                    <CardDescription>
                        Gestiona tu correo electrónico y contraseña.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                    <div className="grid gap-2">
                        <Label htmlFor="email">Correo de la Cuenta</Label>
                        <Input id="email" type="email" defaultValue="creator@investcorp.com" disabled />
                    </div>
                    <Separator />
                        <div className="grid gap-2">
                        <Label htmlFor="current-password">Contraseña Actual</Label>
                        <Input id="current-password" type="password" />
                        </div>
                        <div className="grid gap-2">
                        <Label htmlFor="new-password">Nueva Contraseña</Label>
                        <Input id="new-password" type="password" />
                        </div>
                        <Button>Cambiar Contraseña</Button>
                    </CardContent>
                </Card>
            </div>
            <div className="lg:col-span-1 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><CreditCard className="h-5 w-5"/> Pagos</CardTitle>
                    <CardDescription>
                        Conecta tu cuenta de Stripe para recibir pagos por tus ventas.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                        <div className="flex items-center justify-between rounded-lg border p-4">
                            <div>
                                <p className="font-semibold">Stripe Connect</p>
                                <p className="text-sm text-muted-foreground">Cuenta conectada: acct_...****</p>
                            </div>
                            <Button variant="destructive">Desconectar</Button>
                        </div>
                    </CardContent>
                </Card>
                <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2"><LifeBuoy className="h-5 w-5"/> Soporte</CardTitle>
                        <CardDescription>
                            ¿Necesitas ayuda? Visita nuestra página de soporte para ver las preguntas frecuentes e información de contacto.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Button asChild>
                            <Link href={`/${locale}/support`}>Ir a la Página de Soporte</Link>
                        </Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </AppLayout>
  );
}

    