
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";
import { MessageSquare, BookOpen } from "lucide-react";
import { Label } from "@/components/ui/label";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";

export default function SupportPage() {
  const faqs = [
    {
      question: "¿Cómo creo mi primer agente?",
      answer: "Ve a la página 'Crear Agente', completa la información de persona, conocimiento e instrucciones. Luego, establece un precio y publícalo en el marketplace.",
    },
    {
      question: "¿Cómo funciona el reparto de pagos?",
      answer: "Cuando conectas tu cuenta de Stripe, los pagos se dividen automáticamente. La plataforma retiene una comisión y el resto se envía a tu cuenta.",
    },
    {
      question: "¿Puedo vender un agente fuera del marketplace?",
      answer: "¡Sí! Al crear un agente, puedes optar por mantenerlo 'No listado' y compartir el enlace de venta directamente con tus clientes.",
    },
     {
      question: "¿Cómo integro mi agente con WhatsApp?",
      answer: "En la página de 'Integraciones', selecciona WhatsApp, sigue las instrucciones para conectar tu cuenta de la API de WhatsApp Business (a través de uno de nuestros socios) y vincula el agente deseado.",
    },
  ];
  const translations = {
    dashboard: "Dashboard",
    myAgents: "Mis Agentes",
    sales: "Ventas",
    purchases: "Compras",
    integrations: "Integraciones",
    support: "Soporte",
    marketplace: "Marketplace",
    createAgent: "Crear Agente",
    settings: "Configuración",
    logout: "Cerrar Sesión",
  };

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Soporte y Ayuda
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            ¿Necesitas ayuda? Encuentra respuestas aquí o contáctanos.
        </p>

        <div className="grid md:grid-cols-2 gap-8">
        <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><BookOpen className="h-5 w-5"/> Preguntas Frecuentes (FAQ)</CardTitle>
                </CardHeader>
                <CardContent>
                    <Accordion type="single" collapsible className="w-full">
                        {faqs.map((faq, index) => (
                            <AccordionItem key={index} value={`item-${index}`}>
                                <AccordionTrigger>{faq.question}</AccordionTrigger>
                                <AccordionContent>{faq.answer}</AccordionContent>
                            </AccordionItem>
                        ))}
                    </Accordion>
                </CardContent>
            </Card>
        </div>
            <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><MessageSquare className="h-5 w-5"/> Contáctanos</CardTitle>
                    <CardDescription>Si no encontraste tu respuesta, envíanos un mensaje.</CardDescription>
                </CardHeader>
                <CardContent>
                    <form className="space-y-4">
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="name">Tu Nombre</Label>
                            <Input type="text" id="name" placeholder="Tu nombre completo" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="email">Tu Correo Electrónico</Label>
                            <Input type="email" id="email" placeholder="tu@email.com" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="message">Tu Mensaje</Label>
                            <Textarea placeholder="Describe tu problema o pregunta aquí..." id="message" />
                        </div>
                        <Button className="w-full">Enviar Mensaje</Button>
                    </form>
                </CardContent>
            </Card>
        </div>
        </div>
    </AppLayout>
  );
}
