import { Header } from "@/components/layout/Header";
import { Footer } from "@/components/layout/Footer";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Search, SlidersHorizontal } from "lucide-react";
import { AgentCard } from "@/components/agent/AgentCard";
import { agents } from "@/lib/mock-data";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";


export default function MarketplacePage() {
  return (
    <>
      <Header />
      <main className="flex-grow container py-12 px-4 md:px-8">
        <div className="max-w-7xl mx-auto">
          <div className="text-center mb-12">
             <h1 className="text-4xl font-bold font-headline tracking-tight">
              Marketplace de Agentes
            </h1>
            <p className="text-muted-foreground mt-2">
              Encontre os melhores agentes de IA para automação, análise, criatividade e muito mais.
            </p>
          </div>

          <div className="flex flex-col md:flex-row gap-4 justify-between items-center mb-8 p-4 bg-card border rounded-lg">
            <div className="relative flex-grow w-full md:w-auto">
              <Search className="absolute left-3 top-1/2 -translate-y-1/2 text-muted-foreground" />
              <Input placeholder="Buscar por nome ou função..." className="pl-10 w-full" />
            </div>
            <div className="flex gap-4 w-full md:w-auto">
                <Select>
                    <SelectTrigger className="w-full md:w-[180px]">
                        <SelectValue placeholder="Categoria" />
                    </SelectTrigger>
                    <SelectContent>
                        <SelectItem value="finance">Finanças</SelectItem>
                        <SelectItem value="marketing">Marketing</SelectItem>
                        <SelectItem value="fashion">Moda</SelectItem>
                        <SelectItem value="productivity">Produtividade</SelectItem>
                        <SelectItem value="business">Negócios</SelectItem>
                    </SelectContent>
                </Select>

                <Button variant="outline" className="w-full md:w-auto">
                    <SlidersHorizontal className="mr-2 h-4 w-4" />
                    Filtros
                </Button>
            </div>
          </div>

          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
            {agents.map((agent) => (
              <AgentCard key={agent.id} agent={agent} variant="marketplace" />
            ))}
          </div>

          <div className="text-center mt-12">
            <Button variant="outline" size="lg">Carregar Mais Agentes</Button>
          </div>
        </div>
      </main>
      <Footer />
    </>
  );
}
