
"use client";

import { useFormContext } from "react-hook-form";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { ArrowRight, Bot, CheckCircle, Share2, Sparkles } from "lucide-react";
import { formSchema } from "./CreateAgentForm";
import { z } from "zod";
import { cn } from "@/lib/utils";

const channelIcons = {
    chatEmbedding: <Bot />,
    whatsapp: <Bot />, // Placeholder
    websiteUrl: <Share2 />,
    googleDrive: <Share2 />,
    googleSheets: <Share2 />,
    json: <Share2 />,
    make: <Share2 />,
    zapier: <Share2 />,
    n8n: <Share2 />,
    chatgpt: <Sparkles />,
    gemini: <Sparkles />,
    claude: <Sparkles />,
    midjourney: <Sparkles />,
    runway: <Sparkles />,
};

type FormValues = z.infer<typeof formSchema>;

const ChannelGroup = ({ title, channels, watchPath }: { title: string, channels: any, watchPath: keyof FormValues }) => {
    const { watch } = useFormContext<FormValues>();
    const activeChannels = watch(watchPath);

    const hasActiveChannel = Object.values(activeChannels || {}).some(val => val);

    return (
        <Card className={cn("flex-1", hasActiveChannel ? 'border-primary/50' : '')}>
            <CardHeader>
                <CardTitle className="text-lg">{title}</CardTitle>
            </CardHeader>
            <CardContent className="space-y-2">
                {Object.entries(channels).map(([key, value]) => {
                    const isActive = activeChannels?.[key as keyof typeof activeChannels];
                    if (!isActive) return null;
                    return (
                        <div key={key} className="flex items-center gap-2 text-sm p-2 bg-muted/50 rounded-md">
                            {channelIcons[key as keyof typeof channelIcons]}
                            <span>{value as string}</span>
                            <CheckCircle className="ml-auto h-4 w-4 text-emerald-500" />
                        </div>
                    )
                })}
                {!hasActiveChannel && (
                    <p className="text-sm text-muted-foreground">Nenhum canal ativado.</p>
                )}
            </CardContent>
        </Card>
    )
}

export function AgentFlowDiagram() {
  const inputChannels = {
    chatEmbedding: "Chat Embutido",
    whatsapp: "WhatsApp",
    websiteUrl: "URL de Site",
    googleDrive: "Google Drive",
    googleSheets: "Google Sheets",
    json: "JSON"
  };
  const processingChannels = {
      make: "Make",
      zapier: "Zapier",
      n8n: "n8n",
      chatgpt: "ChatGPT",
      gemini: "Gemini",
      claude: "Claude",
      midjourney: "Midjourney",
      runway: "Runway"
  };
  const outputChannels = {
    chatEmbedding: "Chat Embutido",
    whatsapp: "WhatsApp",
    websiteUrl: "URL de Site (Webhook)",
    googleDrive: "Google Drive",
    googleSheets: "Google Sheets",
    json: "JSON"
  };
  return (
    <Card className="sticky top-24">
        <CardHeader>
            <CardTitle className="font-headline text-2xl flex items-center gap-2">
                <Bot />
                Fluxo do Agente
            </CardTitle>
        </CardHeader>
        <CardContent className="flex flex-col lg:flex-row items-start gap-4">
            <ChannelGroup title="Entrada" channels={inputChannels} watchPath="inputChannels" />
            <div className="self-center p-2 text-muted-foreground"><ArrowRight /></div>
            <ChannelGroup title="Tratamento" channels={processingChannels} watchPath="processingChannels" />
             <div className="self-center p-2 text-muted-foreground"><ArrowRight /></div>
            <ChannelGroup title="Saída" channels={outputChannels} watchPath="outputChannels" />
        </CardContent>
    </Card>
  );
}

