
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { StatsCard } from "@/components/dashboard/StatsCard";
import { SalesChart } from "@/app/[locale]/dashboard/SalesChart";
import { DollarSign, Eye, Users, Bot, FileDown } from "lucide-react";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from "@/components/ui/table";
import { Button } from "@/components/ui/button";

const recentSales = [
  {
    id: "1",
    agentName: "FinancePro Bot",
    buyerName: "John Doe",
    buyerEmail: "john.d@example.com",
    date: "2024-07-20",
    price: 49.99,
  },
  {
    id: "2",
    agentName: "Marketing Guru",
    buyerName: "Jane Smith",
    buyerEmail: "jane.s@example.com",
    date: "2024-07-19",
    price: 79.0,
  },
   {
    id: "3",
    agentName: "FinancePro Bot",
    buyerName: "Peter Jones",
    buyerEmail: "peter.j@example.com",
    date: "2024-07-18",
    price: 49.99,
  },
];


export default function DashboardPage() {
  const translations = {
    dashboard: "Dashboard",
    myAgents: "Meus Agentes",
    sales: "Vendas",
    purchases: "Compras",
    myAccount: "Minha Conta",
    support: "Suporte",
    marketplace: "Marketplace",
    createAgent: "Criar Agente",
    settings: "Configurações",
    logout: "Sair",
    affiliates: "Afiliados",
  };

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline mb-8">Dashboard</h1>
        
        <div className="grid gap-6 md:grid-cols-2 lg:grid-cols-4 mb-8">
          <StatsCard
            title="Vendas Totais"
            value="R$12.450"
            icon={DollarSign}
            change="+12.5% do último mês"
          />
          <StatsCard
            title="Visualizações de Agentes"
            value="245.830"
            icon={Eye}
            change="+8.2% do último mês"
          />
          <StatsCard
            title="Clientes Ativos"
            value="1.284"
            icon={Users}
            change="-1.5% do último mês"
            changeType="decrease"
          />
          <StatsCard
            title="Agentes Ativos"
            value="12"
            icon={Bot}
            change="+2 do último mês"
          />
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div className="lg:col-span-2">
                <SalesChart />
            </div>
            <div>
                 <Card>
                    <CardHeader>
                        <CardTitle>Vendas Recentes</CardTitle>
                        <CardDescription>Uma visão rápida das suas vendas mais recentes.</CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Table>
                             <TableHeader>
                                <TableRow>
                                <TableHead>Agente</TableHead>
                                <TableHead className="text-right">Preço</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                {recentSales.map((sale) => (
                                    <TableRow key={sale.id}>
                                        <TableCell>
                                            <div className="font-medium">{sale.agentName}</div>
                                            <div className="text-sm text-muted-foreground">{sale.buyerEmail}</div>
                                        </TableCell>
                                        <TableCell className="text-right font-semibold text-primary">
                                            R${sale.price.toFixed(2)}
                                        </TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                         <Button variant="outline" className="w-full mt-4">Ver Todas as Vendas</Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </AppLayout>
  );
}
