
"use client";

import Image from "next/image";
import { AppLayout } from "@/components/layout/AppLayout";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Settings } from "lucide-react";

const integrations = [
    {
        name: "WhatsApp",
        description: "Conecte seus agentes ao WhatsApp Business para automação de conversas.",
        logo: "/whatsapp-logo.svg",
        connected: true,
    },
    {
        name: "Instagram",
        description: "Integre com o Messenger do Instagram para engajar seus seguidores.",
        logo: "/instagram-logo.svg",
        connected: false,
    },
    {
        name: "Telegram",
        description: "Use a API de Bots do Telegram para criar agentes interativos.",
        logo: "/telegram-logo.svg",
        connected: false,
    },
     {
        name: "Website",
        description: "Incorpore seu agente em qualquer site com um simples snippet de código.",
        logo: "/website-logo.svg",
        connected: true,
    },
];

export default function IntegrationsPage() {
    const translations = {
        dashboard: "Dashboard",
        myAgents: "Meus Agentes",
        sales: "Vendas",
        purchases: "Compras",
        integrations: "Integrações",
        support: "Suporte",
        marketplace: "Marketplace",
        createAgent: "Criar Agente",
        settings: "Configurações",
        logout: "Sair",
      };
  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Integrações de Canal
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Conecte seus agentes a diferentes canais para alcançar seus clientes onde eles estiverem.
        </p>

        <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
        {integrations.map((integration) => (
            <Card key={integration.name}>
                <CardHeader>
                    <div className="flex items-start justify-between gap-4">
                        <div className="flex items-center gap-4">
                            <Image src={integration.logo} alt={`${integration.name} logo`} width={40} height={40} />
                            <div>
                                <CardTitle className="font-headline text-xl">{integration.name}</CardTitle>
                                <CardDescription className="mt-1">{integration.connected ? "Conectado" : "Não conectado"}</CardDescription>
                            </div>
                        </div>
                    </div>
                </CardHeader>
                <CardContent>
                    <p className="text-sm text-muted-foreground mb-4">{integration.description}</p>
                     <Button variant={integration.connected ? "secondary" : "default"} className="w-full">
                        {integration.connected ? <Settings className="mr-2 h-4 w-4"/> : null}
                        {integration.connected ? "Gerenciar" : "Conectar"}
                    </Button>
                </CardContent>
            </Card>
        ))}
        </div>
    </AppLayout>
  );
}
