
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import { Avatar, AvatarFallback, AvatarImage } from "@/components/ui/avatar";
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { Textarea } from "@/components/ui/textarea";
import { CreditCard, Shield, LifeBuoy, Mail, Phone, Link as LinkIcon, Globe } from "lucide-react";
import { Separator } from "@/components/ui/separator";
import Link from "next/link";
import { usePathname } from "next/navigation";

export default function SettingsPage() {
    const pathname = usePathname();
    const locale = pathname.split('/')[1] || 'pt';

    const translations = {
        dashboard: "Dashboard",
        myAgents: "Meus Agentes",
        sales: "Vendas",
        purchases: "Compras",
        myAccount: "Minha Conta",
        support: "Suporte",
        marketplace: "Marketplace",
        createAgent: "Criar Agente",
        settings: "Configurações",
        logout: "Sair",
        affiliates: "Afiliados",
      };

    const SocialInput = ({ id, name, placeholder, icon: Icon }: { id: string, name: string, placeholder: string, icon: React.ElementType }) => (
         <div className="grid gap-2">
            <Label htmlFor={id}>{name}</Label>
            <div className="flex items-center gap-2">
                <Icon className="h-5 w-5 text-muted-foreground" />
                <Input id={id} placeholder={placeholder} />
            </div>
        </div>
    );

  return (
    <AppLayout translations={translations}>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Minha Conta
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Gerencie suas informações de perfil, pagamentos e segurança.
        </p>
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div className="lg:col-span-2 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle>Perfil Público</CardTitle>
                    <CardDescription>
                        Estas informações serão exibidas em sua página de criador.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-6">
                        <div className="flex items-center gap-4">
                        <Avatar className="h-16 w-16">
                            <AvatarImage src="https://placehold.co/100x100.png" alt="Creator Name" />
                            <AvatarFallback>CN</AvatarFallback>
                        </Avatar>
                        <Button variant="outline">Alterar Foto</Button>
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="fullName">Nome de Exibição</Label>
                        <Input id="fullName" defaultValue="InvestCorp" />
                    </div>
                    <div className="grid gap-2">
                        <Label htmlFor="bio">Bio</Label>
                        <Textarea id="bio" defaultValue="Pioneiros em IA para o mercado financeiro, criando bots que simplificam análises complexas e auxiliam em decisões de investimento." />
                    </div>
                    <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
                        <SocialInput id="public-email" name="Email Público" placeholder="contato@exemplo.com" icon={Mail} />
                        <SocialInput id="phone" name="Telefone" placeholder="+55 (11) 99999-9999" icon={Phone} />
                        <SocialInput id="website" name="Website" placeholder="https://exemplo.com.br" icon={Globe} />
                        <SocialInput id="twitter" name="Twitter" placeholder="https://twitter.com/usuario" icon={LinkIcon} />
                        <SocialInput id="linkedin" name="LinkedIn" placeholder="https://linkedin.com/in/usuario" icon={LinkIcon} />
                        <SocialInput id="github" name="GitHub" placeholder="https://github.com/usuario" icon={LinkIcon} />
                    </div>
                    <Button>Salvar Perfil</Button>
                    </CardContent>
                </Card>

                 <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><Shield className="h-5 w-5"/> Segurança</CardTitle>
                    <CardDescription>
                        Gerencie seu e-mail e senha.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                    <div className="grid gap-2">
                        <Label htmlFor="email">Email da Conta</Label>
                        <Input id="email" type="email" defaultValue="creator@investcorp.com" disabled />
                    </div>
                    <Separator />
                        <div className="grid gap-2">
                        <Label htmlFor="current-password">Senha Atual</Label>
                        <Input id="current-password" type="password" />
                        </div>
                        <div className="grid gap-2">
                        <Label htmlFor="new-password">Nova Senha</Label>
                        <Input id="new-password" type="password" />
                        </div>
                        <Button>Alterar Senha</Button>
                    </CardContent>
                </Card>
            </div>
            <div className="lg:col-span-1 space-y-8">
                <Card>
                    <CardHeader>
                    <CardTitle className="flex items-center gap-2"><CreditCard className="h-5 w-5"/> Pagamentos</CardTitle>
                    <CardDescription>
                        Conecte sua conta Stripe para receber pagamentos por suas vendas.
                    </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                        <div className="flex items-center justify-between rounded-lg border p-4">
                            <div>
                                <p className="font-semibold">Stripe Connect</p>
                                <p className="text-sm text-muted-foreground">Conta conectada: acct_...****</p>
                            </div>
                            <Button variant="destructive">Desconectar</Button>
                        </div>
                    </CardContent>
                </Card>
                 <Card>
                    <CardHeader>
                        <CardTitle className="flex items-center gap-2"><LifeBuoy className="h-5 w-5"/> Suporte</CardTitle>
                        <CardDescription>
                            Precisa de ajuda? Visite nossa página de suporte para FAQs e informações de contato.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Button asChild>
                            <Link href={`/${locale}/support`}>Ir para a Página de Suporte</Link>
                        </Button>
                    </CardContent>
                </Card>
            </div>
        </div>
    </AppLayout>
  );
}

    