
"use client";

import { AppLayout } from "@/components/layout/AppLayout";
import {
  Card,
  CardContent,
  CardDescription,
  CardHeader,
  CardTitle,
} from "@/components/ui/card";
import {
  Accordion,
  AccordionContent,
  AccordionItem,
  AccordionTrigger,
} from "@/components/ui/accordion";
import { MessageSquare, BookOpen } from "lucide-react";
import { Label } from "@/components/ui/label";
import { Input } from "@/components/ui/input";
import { Textarea } from "@/components/ui/textarea";
import { Button } from "@/components/ui/button";

export default function SupportPage() {
  const faqs = [
    {
      question: "Como eu crio meu primeiro agente?",
      answer: "Vá para a página 'Criar Agente', preencha as informações de persona, conhecimento e instruções. Depois, defina um preço e publique no marketplace.",
    },
    {
      question: "Como funciona o split de pagamento?",
      answer: "Ao conectar sua conta Stripe, os pagamentos são divididos automaticamente. A plataforma retém uma comissão e o restante é enviado para sua conta.",
    },
    {
      question: "Posso vender um agente fora do marketplace?",
      answer: "Sim! Ao criar um agente, você pode optar por deixá-lo 'Não listado' e compartilhar o link de venda diretamente com seus clientes.",
    },
     {
      question: "Como integro meu agente com o WhatsApp?",
      answer: "Na página de 'Integrações', selecione WhatsApp, siga as instruções para conectar sua conta da API do WhatsApp Business (via um de nossos parceiros) e vincule o agente desejado.",
    },
  ];

  return (
    <AppLayout>
        <h1 className="text-3xl font-bold font-headline tracking-tight">
            Suporte e Ajuda
        </h1>
        <p className="text-muted-foreground mb-8 mt-1">
            Precisa de ajuda? Encontre respostas aqui ou entre em contato conosco.
        </p>

        <div className="grid md:grid-cols-2 gap-8">
        <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><BookOpen className="h-5 w-5"/> Perguntas Frequentes (FAQ)</CardTitle>
                </CardHeader>
                <CardContent>
                    <Accordion type="single" collapsible className="w-full">
                        {faqs.map((faq, index) => (
                            <AccordionItem key={index} value={`item-${index}`}>
                                <AccordionTrigger>{faq.question}</AccordionTrigger>
                                <AccordionContent>{faq.answer}</AccordionContent>
                            </AccordionItem>
                        ))}
                    </Accordion>
                </CardContent>
            </Card>
        </div>
            <div className="space-y-8">
            <Card>
                <CardHeader>
                    <CardTitle className="flex items-center gap-2"><MessageSquare className="h-5 w-5"/> Fale Conosco</CardTitle>
                    <CardDescription>Se não encontrou sua resposta, envie-nos uma mensagem.</CardDescription>
                </CardHeader>
                <CardContent>
                    <form className="space-y-4">
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="name">Seu Nome</Label>
                            <Input type="text" id="name" placeholder="Seu nome completo" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="email">Seu Email</Label>
                            <Input type="email" id="email" placeholder="seu@email.com" />
                        </div>
                        <div className="grid w-full items-center gap-1.5">
                            <Label htmlFor="message">Sua Mensagem</Label>
                            <Textarea placeholder="Descreva seu problema ou dúvida aqui..." id="message" />
                        </div>
                        <Button className="w-full">Enviar Mensagem</Button>
                    </form>
                </CardContent>
            </Card>
        </div>
        </div>
    </AppLayout>
  );
}
