
"use client";

import {
  Dialog,
  DialogContent,
  DialogDescription,
  DialogHeader,
  DialogTitle,
  DialogTrigger,
} from "@/components/ui/dialog";
import { Card, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Text, Image, Share2, ArrowRight } from "lucide-react";
import Link from "next/link";
import { cn } from "@/lib/utils";

interface AgentTypeSelectionDialogProps {
    trigger: React.ReactNode;
    locale: string;
}

const translations = {
    pt: {
        title: "Qual tipo de agente você quer criar?",
        description: "Escolha um modelo para começar.",
        internalAgent: "Agente Interno",
        internalDescription: "Crie agentes de texto e imagem com bases de conhecimento customizadas.",
        externalAgent: "Agente Externo",
        externalDescription: "Conecte seu agente a ferramentas externas como Make, Zapier, e mais.",
        comingSoon: "Em Breve"
    },
    en: {
        title: "What type of agent do you want to create?",
        description: "Choose a template to get started.",
        internalAgent: "Internal Agent",
        internalDescription: "Create text and image agents with custom knowledge bases.",
        externalAgent: "External Agent",
        externalDescription: "Connect your agent to external tools like Make, Zapier, and more.",
        comingSoon: "Coming Soon"
    },
    es: {
        title: "¿Qué tipo de agente quieres crear?",
        description: "Elige una plantilla para empezar.",
        internalAgent: "Agente Interno",
        internalDescription: "Crea agentes de texto e imagen con bases de conocimiento personalizadas.",
        externalAgent: "Agente Externo",
        externalDescription: "Conecta tu agente a herramientas externas como Make, Zapier y más.",
        comingSoon: "Próximamente"
    }
}


export function AgentTypeSelectionDialog({ trigger, locale }: AgentTypeSelectionDialogProps) {
    const t = translations[locale as keyof typeof translations] || translations.pt;
  return (
    <Dialog>
      <DialogTrigger asChild>{trigger}</DialogTrigger>
      <DialogContent className="sm:max-w-[650px]">
        <DialogHeader>
          <DialogTitle className="text-2xl font-headline">{t.title}</DialogTitle>
          <DialogDescription>
            {t.description}
          </DialogDescription>
        </DialogHeader>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4 pt-4">
            <Card className="hover:bg-accent/50 transition-colors">
                <Link href={`/${locale}/create-agent`} className="flex flex-col justify-between h-full p-6">
                    <div>
                        <div className="flex items-center gap-2 mb-2">
                            <Text className="h-5 w-5 text-primary" />
                            <Image className="h-5 w-5 text-primary" />
                        </div>
                        <CardTitle className="text-lg font-bold">{t.internalAgent}</CardTitle>
                        <CardDescription className="mt-1">{t.internalDescription}</CardDescription>
                    </div>
                    <div className="flex justify-end items-center mt-4">
                        <ArrowRight className="h-5 w-5 text-primary" />
                    </div>
                </Link>
            </Card>
             <Card className="hover:bg-accent/50 transition-colors">
                <Link href={`/${locale}/create-external-agent`} className="flex flex-col justify-between h-full p-6">
                    <div>
                        <div className="flex items-center gap-2 mb-2">
                           <Share2 className="h-5 w-5 text-primary" />
                        </div>
                        <CardTitle className="text-lg font-bold">{t.externalAgent}</CardTitle>
                        <CardDescription className="mt-1">{t.externalDescription}</CardDescription>
                    </div>
                    <div className="flex justify-end items-center mt-4">
                        <ArrowRight className="h-5 w-5 text-primary" />
                    </div>
                </Link>
            </Card>
        </div>
      </DialogContent>
    </Dialog>
  );
}
