import Link from "next/link";
import { Logo } from "./Logo";
import { Github, Twitter, Linkedin } from "lucide-react";

export function Footer() {
  const footerLinks = [
    { title: "Marketplace", href: "/" },
    { title: "Criar Agente", href: "/create-agent" },
    { title: "Dashboard", href: "/dashboard" },
    { title: "Sobre Nós", href: "#" },
    { title: "Contato", href: "#" },
    { title: "Termos de Serviço", href: "#" },
    { title: "Política de Privacidade", href: "#" },
  ];

  const socialLinks = [
    { icon: Twitter, href: "#" },
    { icon: Github, href: "#" },
    { icon: Linkedin, href: "#" },
  ];

  return (
    <footer className="border-t">
      <div className="container py-12 px-4 md:px-8">
        <div className="grid grid-cols-1 md:grid-cols-5 gap-8">
          <div className="md:col-span-2">
            <Link href="/" className="flex items-center space-x-2 mb-4">
              <Logo />
              <span className="text-lg font-bold font-headline">Agenmax</span>
            </Link>
            <p className="text-muted-foreground text-sm max-w-xs">
              O principal marketplace para descobrir, criar e implantar agentes de IA inteligentes.
            </p>
          </div>
          <div className="md:col-span-3 grid grid-cols-2 md:grid-cols-3 gap-8">
            <div>
              <h3 className="font-semibold mb-4">Plataforma</h3>
              <ul className="space-y-2">
                {footerLinks.slice(0, 3).map((link) => (
                  <li key={link.title}>
                    <Link href={link.href} className="text-sm text-muted-foreground hover:text-foreground">
                      {link.title}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            <div>
              <h3 className="font-semibold mb-4">Empresa</h3>
              <ul className="space-y-2">
                {footerLinks.slice(3, 5).map((link) => (
                  <li key={link.title}>
                    <Link href={link.href} className="text-sm text-muted-foreground hover:text-foreground">
                      {link.title}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
            <div>
              <h3 className="font-semibold mb-4">Legal</h3>
              <ul className="space-y-2">
                {footerLinks.slice(5, 7).map((link) => (
                  <li key={link.title}>
                    <Link href={link.href} className="text-sm text-muted-foreground hover:text-foreground">
                      {link.title}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
          </div>
        </div>
        <div className="mt-8 pt-8 border-t flex flex-col sm:flex-row justify-between items-center">
          <p className="text-sm text-muted-foreground">&copy; {new Date().getFullYear()} Agenmax. Todos os direitos reservados.</p>
          <div className="flex items-center space-x-4 mt-4 sm:mt-0">
            {socialLinks.map((social, index) => (
              <Link key={index} href={social.href} className="text-muted-foreground hover:text-foreground">
                <social.icon className="h-5 w-5" />
              </Link>
            ))}
          </div>
        </div>
      </div>
    </footer>
  );
}
