
"use client";

import Link from "next/link";
import { Button } from "@/components/ui/button";
import { Logo } from "./Logo";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuLabel,
  DropdownMenuSeparator,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu"
import { Avatar, AvatarFallback, AvatarImage } from "../ui/avatar";
import { LifeBuoy, LogOut, Settings, User } from "lucide-react";
import { ThemeSwitcher } from "./ThemeSwitcher";
import { LanguageSwitcher } from "./LanguageSwitcher";
import { AgentTypeSelectionDialog } from "../agent/AgentTypeSelectionDialog";
import { usePathname } from "next/navigation";


// Change this to true to see the logged in header
const IS_LOGGED_IN = false;

const LoggedOutNav = ({ locale }: { locale: string }) => {
    return (
      <div className="flex items-center space-x-2">
          <Button variant="ghost" asChild>
              <Link href={`/${locale}/login`}>Login</Link>
          </Button>
          <Button asChild>
              <Link href={`/${locale}/signup`}>Sign Up</Link>
          </Button>
      </div>
    );
}

const LoggedInNav = ({ locale }: { locale: string }) => {
    return (
      <div className="flex items-center gap-4">
        <ThemeSwitcher />
        <LanguageSwitcher />
        <DropdownMenu>
          <DropdownMenuTrigger asChild>
            <Button variant="ghost" className="relative h-8 w-8 rounded-full">
                <Avatar className="h-9 w-9">
                    <AvatarImage src="https://placehold.co/40x40.png" alt="User" />
                    <AvatarFallback>U</AvatarFallback>
                </Avatar>
            </Button>
          </DropdownMenuTrigger>
          <DropdownMenuContent className="w-56" align="end" forceMount>
            <DropdownMenuLabel className="font-normal">
              <div className="flex flex-col space-y-1">
                <p className="text-sm font-medium leading-none">InvestCorp</p>
                <p className="text-xs leading-none text-muted-foreground">
                  creator@investcorp.com
                </p>
              </div>
            </DropdownMenuLabel>
            <DropdownMenuSeparator />
            <DropdownMenuItem asChild>
                <Link href={`/${locale}/profile`}><User className="mr-2 h-4 w-4" />Profile</Link>
            </DropdownMenuItem>
            <DropdownMenuItem asChild>
                <Link href={`/${locale}/settings`}><Settings className="mr-2 h-4 w-4" />Settings</Link>
            </DropdownMenuItem>
             <DropdownMenuItem asChild>
                <Link href={`/${locale}/support`}><LifeBuoy className="mr-2 h-4 w-4" />Support</Link>
            </DropdownMenuItem>
            <DropdownMenuSeparator />
            <DropdownMenuItem asChild>
               <Link href={`/${locale}`}><LogOut className="mr-2 h-4 w-4" />Logout</Link>
            </DropdownMenuItem>
          </DropdownMenuContent>
        </DropdownMenu>
      </div>
    )
}


export function Header() {
  const pathname = usePathname();
  const locale = pathname.split('/')[1] || 'pt';

  const navLinks = [
    { href: `/${locale}/marketplace`, label: "Marketplace" },
    { href: `/${locale}/create-agent`, label: "Create Agent", dialog: true },
  ];

  return (
    <header className="sticky top-0 z-50 w-full border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60">
      <div className="container flex h-14 items-center">
        <div className="mr-4 flex items-center">
          <Link href={`/${locale}`} className="mr-6 flex items-center space-x-2">
            <Logo />
            <span className="font-bold font-headline">Agenmax</span>
          </Link>
           <nav className="hidden md:flex items-center space-x-6 text-sm font-medium">
            {navLinks.map(({ href, label, dialog }) => {
                if (dialog) {
                    return (
                        <AgentTypeSelectionDialog 
                            key={label}
                            locale={locale}
                            trigger={
                                <button className="transition-colors hover:text-foreground/80 text-foreground/60">
                                    {label}
                                </button>
                            }
                        />
                    )
                }
                return (
                     <Link
                        key={label}
                        href={href}
                        className="transition-colors hover:text-foreground/80 text-foreground/60"
                    >
                        {label}
                    </Link>
                )
            })}
          </nav>
        </div>
        <div className="flex flex-1 items-center justify-end space-x-2">
           <ThemeSwitcher />
           <LanguageSwitcher />
          {IS_LOGGED_IN ? <LoggedInNav locale={locale}/> : <LoggedOutNav locale={locale}/>}
        </div>
      </div>
    </header>
  );
}
